/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Transaction;

/**
 * @author akima
 */
public class TransactionWrapper implements Transaction {

	/**
	 *  
	 */
	public TransactionWrapper(Transaction wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected final Transaction wrapped;

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void commit() throws HibernateException {
		wrapped.commit();
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void rollback() throws HibernateException {
		wrapped.rollback();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public boolean wasCommitted() throws HibernateException {
		return wrapped.wasCommitted();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public boolean wasRolledBack() throws HibernateException {
		return wrapped.wasRolledBack();
	}

}