/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/25
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.jdbc.wrapper.DataSourceWrapper;

/**
 * @author akima
 */
public class LogDataSource extends DataSourceWrapper {

    /**
     * @param dataSource
     */
    public LogDataSource(DataSource dataSource) {
        this(dataSource, new CascadeNamedLog(dataSource.getClass(), DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param dataSource
     */
    public LogDataSource(DataSource dataSource, CascadeNamedLog log) {
        super(dataSource);
        this.log = log;
    }

    /**
     * @see org.asyrinx.brownie.jdbc.wrapper.DataSourceWrapper#getConnection()
     */
    public Connection getConnection() throws SQLException {
        return toLogConnection(super.getConnection());
    }

    /**
     * @see org.asyrinx.brownie.jdbc.wrapper.DataSourceWrapper#getConnection(java.lang.String,
     *      java.lang.String)
     */
    public Connection getConnection(String username, String password) throws SQLException {
        return toLogConnection(super.getConnection(username, password));
    }

    protected Connection toLogConnection(Connection connection) {
        return LogConnectionFilter.log(connection, this.log.subLog(connection));
    }

    protected final CascadeNamedLog log;

    /**
     * @return
     */
    public String getDefaultLevel() {
        return log.getDefaultLevel();
    }

    /**
     * @return
     */
    public String getLoggerName() {
        return log.getLoggerName();
    }

    /**
     * @param string
     */
    public void setDefaultLevel(String string) {
        log.setDefaultLevel(string);
    }

    /**
     * @param loggerName
     */
    public void setLoggerName(String loggerName) {
        log.setLoggerName(loggerName);
    }

}