/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/27 19:34:35
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.jdbc.wrapper.XAConnectionWrapper;

/**
 * @author takeshi
 */
public class LogXAConnection extends XAConnectionWrapper {

    /**
     * @param wrapped
     */
    public LogXAConnection(XAConnection wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param wrapped
     */
    public LogXAConnection(XAConnection wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    protected final CascadeNamedLog log;

    public void addConnectionEventListener(ConnectionEventListener listener) {
        super.addConnectionEventListener(listener);
        log.log("addConnectionEventListener(" + listener + ")");
    }

    public void close() throws SQLException {
        try {
            super.close();
            log.log("close()");
        } catch (SQLException e) {
            log.error("failed to close() ", e);
            throw e;
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            final Connection result = super.getConnection();
            log.log("getConnection(): " + result);
            return new LogConnection(result, this.log.subLog(result));
        } catch (SQLException e) {
            log.error("failed to getConnection(): ", e);
            throw e;
        }
    }

    public XAResource getXAResource() throws SQLException {
        try {
            final XAResource result = super.getXAResource();
            log.log("getXAResource(): " + result);
            return new LogXAResource(result, this.log.subLog(result));
        } catch (SQLException e) {
            log.error("failed to getXAResource(): ", e);
            throw e;
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        super.removeConnectionEventListener(listener);
        log.log("removeConnectionEventListener(" + listener + ")");
    }
}