/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/11
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * @author akima
 */
public class ResultSetMetaDataWrapper extends Wrapper implements
		ResultSetMetaData {

	/**
	 * @param wrapped
	 */
	public ResultSetMetaDataWrapper(ResultSetMetaData resultSetMetaData) {
		super(resultSetMetaData);
		this.resultSetMetaData = resultSetMetaData;
	}

	private final ResultSetMetaData resultSetMetaData;

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getCatalogName(int column) throws SQLException {
		return resultSetMetaData.getCatalogName(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getColumnClassName(int column) throws SQLException {
		return resultSetMetaData.getColumnClassName(column);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getColumnCount() throws SQLException {
		return resultSetMetaData.getColumnCount();
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getColumnDisplaySize(int column) throws SQLException {
		return resultSetMetaData.getColumnDisplaySize(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getColumnLabel(int column) throws SQLException {
		return resultSetMetaData.getColumnLabel(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getColumnName(int column) throws SQLException {
		return resultSetMetaData.getColumnName(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getColumnType(int column) throws SQLException {
		return resultSetMetaData.getColumnType(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getColumnTypeName(int column) throws SQLException {
		return resultSetMetaData.getColumnTypeName(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getPrecision(int column) throws SQLException {
		return resultSetMetaData.getPrecision(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getScale(int column) throws SQLException {
		return resultSetMetaData.getScale(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getSchemaName(int column) throws SQLException {
		return resultSetMetaData.getSchemaName(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getTableName(int column) throws SQLException {
		return resultSetMetaData.getTableName(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isAutoIncrement(int column) throws SQLException {
		return resultSetMetaData.isAutoIncrement(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isCaseSensitive(int column) throws SQLException {
		return resultSetMetaData.isCaseSensitive(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isCurrency(int column) throws SQLException {
		return resultSetMetaData.isCurrency(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isDefinitelyWritable(int column) throws SQLException {
		return resultSetMetaData.isDefinitelyWritable(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int isNullable(int column) throws SQLException {
		return resultSetMetaData.isNullable(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isReadOnly(int column) throws SQLException {
		return resultSetMetaData.isReadOnly(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isSearchable(int column) throws SQLException {
		return resultSetMetaData.isSearchable(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isSigned(int column) throws SQLException {
		return resultSetMetaData.isSigned(column);
	}

	/**
	 * @param column
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isWritable(int column) throws SQLException {
		return resultSetMetaData.isWritable(column);
	}

}