/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/12 16:17:20
 */
package org.asyrinx.brownie.seasar.aop;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.aopalliance.intercept.MethodInvocation;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

/**
 * @author takeshi
 */
public class CacheInterceptor extends AbstractInterceptor {

    private final Map resultMap = new HashMap();

    /*
     * (non-Javadoc)
     * 
     * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        final List keyList = ArrayUtils.toArrayList(invocation.getArguments());
        keyList.add(0, invocation.getMethod().getName());
        if (resultMap.containsKey(keyList)) {
            final Object result = resultMap.get(keyList);
            return result;
        }
        final Object result = invocation.proceed();
        resultMap.put(keyList, result);
        return result;
    }

}