/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/06/11 2:05:25
 */
package org.asyrinx.brownie.seasar.container.factory;

import java.io.IOException;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.container.factory.S2ContainerTagHandlerRule;
import org.seasar.framework.container.factory.XmlS2ContainerBuilder;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.framework.xml.TagHandlerContext;

/**
 * @author akima
 */
public class BrownieXmlS2ContainerBuilder implements S2ContainerBuilder {

	private static S2ContainerTagHandlerRule rule_ = new BrownieS2ContainerTagHandlerRule();

	public BrownieXmlS2ContainerBuilder() {
		this(StreamFactoryFacade.newFacade());
	}

	public BrownieXmlS2ContainerBuilder(StreamFactory streamFactory) {
		this.streamFactory = streamFactory;
	}

	protected final StreamFactory streamFactory;

	public S2Container build(String path, ClassLoader classLoader) {
		S2Container container = null;
		ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
		try {
			if (classLoader != null) {
				Thread.currentThread().setContextClassLoader(classLoader);
			}
			container = build(path);
		} finally {
			Thread.currentThread().setContextClassLoader(oldLoader);
		}
		return container;
	}

	public S2Container build(String path) {
		final SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
		factory.setValidating(true);
		final SAXParser saxParser = SAXParserFactoryUtil.newSAXParser(factory);
		final SaxHandler handler = new SaxHandler(rule_);
		handler.registerDtdPath(XmlS2ContainerBuilder.PUBLIC_ID,
				XmlS2ContainerBuilder.DTD_PATH);
		final SaxHandlerParser parser = new SaxHandlerParser(handler, saxParser);
		/*
		 * ςĂ܂B
		 */
		try {
			return (S2Container) parser.parse(streamFactory.newInput(path));
		} catch (IOException e) {
			throw new IORuntimeException(e);
		}
	}
	
	/* (non-Javadoc)
     * @see org.seasar.framework.container.factory.S2ContainerBuilder#include(org.seasar.framework.container.S2Container, java.lang.String)
     */
    public S2Container include(S2Container parent, String path) {
		SaxHandlerParser parser = createSaxHandlerParser(parent, path);
		return (S2Container) parser.parse(path);
    }
	
	private SaxHandlerParser createSaxHandlerParser(S2Container parent, String path) {
		SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
		factory.setValidating(true);
		SAXParser saxParser = SAXParserFactoryUtil.newSAXParser(factory);
		SaxHandler handler = new SaxHandler(rule_);
		TagHandlerContext ctx = handler.getTagHandlerContext(); 
		ctx.addParameter("parent", parent);
		ctx.addParameter("path", path);
		handler.registerDtdPath(XmlS2ContainerBuilder.PUBLIC_ID, XmlS2ContainerBuilder.DTD_PATH);
		return new SaxHandlerParser(handler, saxParser);
	}
}