/*
 * joey and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/07/11 21:11:11
 */
package org.asyrinx.brownie.swing.content;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import org.asyrinx.brownie.swing.GuiRuntimeException;

/**
 * @author akima
 */
public class ContentDialog extends JDialog {

	protected final Component content;

	/**
	 * 
	 * @param content
	 * @param owner
	 * @param title
	 * @param modal
	 * @throws HeadlessException
	 */
	public ContentDialog(Component content, Dialog owner, String title,
			boolean modal) throws HeadlessException {
		super(owner, title, modal);
		this.content = content;
		intiPane();
	}

	/**
	 * @param content
	 * @param owner
	 * @param title
	 * @param modal
	 * @throws java.awt.HeadlessException
	 */
	public ContentDialog(Component content, Frame owner, String title,
			boolean modal) throws HeadlessException {
		super(owner, title, modal);
		this.content = content;
		intiPane();
	}

	/**
	 * 
	 * @param content
	 * @param owner
	 * @param title
	 * @param modal
	 * @return
	 */
	public static ContentDialog create(Component content, Component owner,
			String title, boolean modal) {
		if (owner instanceof Frame) {
			return new ContentDialog(content, (Frame) owner, title, modal);
		} else if (owner instanceof Dialog) {
			return new ContentDialog(content, (Dialog) owner, title, modal);
		} else {
			final Window window = SwingUtilities.getWindowAncestor(owner);
			if (window instanceof Frame) {
				return new ContentDialog(content, (Frame) window, title, modal);
			} else if (window instanceof Dialog) {
				return new ContentDialog(content, (Dialog) window, title, modal);
			} else {
				throw new GuiRuntimeException(
						"owner and its window don't extended Frame or Dialog.");
			}
		}
	}

	protected void intiPane() {
		if (content instanceof Container) {
			this.setContentPane((Container) content);
		} else {
			final JPanel panel = new JPanel();
			panel.add(content);
			this.setContentPane(panel);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Dialog#show()
	 */
	public void show() {
		invokeBeforeShow();
		super.show();
		invokeAfterShow();
	}

	/**
	 *  
	 */
	protected void invokeBeforeShow() {
		if (content instanceof WindowContent)
			((WindowContent) content).beforeShow();
	}

	/**
	 *  
	 */
	protected void invokeAfterShow() {
		if (content instanceof WindowContent)
			((WindowContent) content).afterShow();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Dialog#hide()
	 */
	public void hide() {
		invokeBeforeHide();
		super.hide();
		invokeAfterHide();
	}

	/**
	 *  
	 */
	protected void invokeBeforeHide() {
		if (content instanceof WindowContent)
			((WindowContent) content).beforeHide();
	}

	/**
	 *  
	 */
	protected void invokeAfterHide() {
		if (content instanceof WindowContent)
			((WindowContent) content).afterHide();
	}

}