/*
 * joey and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/04/09 15:17:19
 */
package org.asyrinx.brownie.tapestry.seasar;

import java.util.Map;

import org.apache.tapestry.engine.BaseEngine;
import org.apache.tapestry.request.RequestContext;
import org.asyrinx.brownie.seasar.servlet.S2ContainerLoader;
import org.seasar.framework.container.S2Container;

/**
 * @author akima
 */
public class S2AppEngine extends BaseEngine {

    public static final String APPLICATION_CONTEXT_KEY = "s2container";

    /**
     * @see org.apache.tapestry.engine.AbstractEngine#setupForRequest(org.apache.tapestry.request.RequestContext)
     */
    protected void setupForRequest(RequestContext context) {
        super.setupForRequest(context);
        // insert ApplicationContext in global, if not there
        final Map global = (Map) getGlobal();
        S2Container container = getContainer(global);
        if (container == null) {
            container = S2ContainerLoader.getContainer(context.getServlet().getServletContext());
            global.put(APPLICATION_CONTEXT_KEY, container);
        }
    }

    /**
     * @param global
     * @return
     */
    public static S2Container getContainer(final Map global) {
        return (S2Container) global.get(APPLICATION_CONTEXT_KEY);
    }

    /**
     * @return
     */
    public S2Container getContainer() {
        return getContainer((Map) getGlobal());
    }

}