/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/28
 */
package test.org.asyrinx.brownie.core.collection;

import java.util.Map;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.collection.WeakReferencedValueMap;

/**
 * @author akima
 */
public class WeakReferencedValueMapTest extends TestCase {

	/**
	 * Constructor for WeakReferencedValueMapTest.
	 * @param name
	 */
	public WeakReferencedValueMapTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(WeakReferencedValueMapTest.class);
	}

	public void testWeakRef() {
		final Map weakRefMap = new WeakReferencedValueMap();
		final String value1 = "d1";
		weakRefMap.put("k1", value1);
		weakRefMap.put("k2", new String("d2"));
		System.gc();
		try {
			Thread.sleep(100);
		} catch (InterruptedException e) {
			e.printStackTrace();
			fail();
		}
		assertEquals("d1", weakRefMap.get("k1"));
		assertEquals(null, weakRefMap.get("k2"));
	}

}
