/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/20 22:44:21
 */
package test.org.asyrinx.brownie.core.csv;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.collection.CollectionUtils;
import org.asyrinx.brownie.core.csv.PropertySVBeanMapper;

/**
 * @author akima
 */
public class PropertySVBeanMapperTest extends TestCase {

	/**
	 * Constructor for PropertySVBeanMapperTest.
	 * @param arg0
	 */
	public PropertySVBeanMapperTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(PropertySVBeanMapperTest.class);
	}

	private static final DateFormat format4Assert =
		new SimpleDateFormat("yyyy/MM/dd");

	private String toSystemDateFormat(String dateString) {
		final Date date;
		try {
			date = format4Assert.parse(dateString);
		} catch (ParseException e) {
			return "1999/12/31";
		}
		return DateFormat.getDateInstance().format(date);
	}

	public void testLoadBean() {

		final PropertySVBeanMapper mapper;
		try {
			mapper =
				new PropertySVBeanMapper(
					"test.org.asyrinx.brownie.core.csv.TestBean1",
					"test/org/asyrinx/brownie/core/csv/testBean1Prop.properties");
		} catch (IOException e) {
			e.printStackTrace();
			fail();
			return;
		}
		final List data1 =
			CollectionUtils.toList(
				new String[] {
					"100",
					"SSSSSS1",
					toSystemDateFormat("2004/05/20"),
					"false",
					"bean1",
					"987654321",
					"" });
		Object obj;
		try {
			obj = mapper.loadBean(data1);
		} catch (Throwable e) {
			e.printStackTrace();
			fail();
			return;
		}
		assertEquals(obj.getClass(), TestBean1.class);
		TestBean1 bean1 = (TestBean1) obj;
		assertEquals(100, bean1.getIntValue());
		assertEquals(987654321, bean1.getLongValue());
		assertEquals(false, bean1.isBooleanValue());
		assertEquals("bean1", bean1.getStringValue());
		assertEquals("2004/05/20", format4Assert.format(bean1.getDateValue()));
		assertEquals(TestEnum1.VAL_1, bean1.getEnum1Value());
		//		100,SSSSSS1,2004/5/20,FALSE,bean1,987654321,
		//		108,SSSSSS2,1969/10/10,TRUE,bean2,1234567890,カカ`

	}

}
