/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/21 10:08:54
 */
package test.org.asyrinx.brownie.core.csv;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.csv.PropertySVBeanMapper;
import org.asyrinx.brownie.core.csv.SimpleSVBeanLoader;
import org.asyrinx.brownie.core.csv.SimpleSVParser;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;

/**
 * @author akima
 */
public class SimpleSVBeanLoaderTest extends TestCase {

	/**
	 * Constructor for SimpleSVBeanLoaderTest.
	 * @param arg0
	 */
	public SimpleSVBeanLoaderTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(SimpleSVBeanLoaderTest.class);
	}

	private static final DateFormat format4Assert =
		new SimpleDateFormat("yyyy/MM/dd");

	public void testLoad() {
		final List loadedBeans = new ArrayList();
		final SimpleSVBeanLoader beanLoader;
		try {
			beanLoader =
				new SimpleSVBeanLoader(
					new SimpleSVParser(),
					new PropertySVBeanMapper(
						"test.org.asyrinx.brownie.core.csv.TestBean1",
						"test/org/asyrinx/brownie/core/csv/testBean1Prop.properties")) {
				/* (non-Javadoc)
				 * @see org.asyrinx.brownie.core.csv.SimpleSVBeanLoader#loadBean(java.util.List)
				 */
				protected Object loadBean(List lines) {
					final Object result = super.loadBean(lines);
					loadedBeans.add(result);
					return result;
				}
			};
			beanLoader.load(
				StreamFactoryFacade.newFacade().newInput(
					"test/org/asyrinx/brownie/core/csv/testBean1Data.csv"));
			/*
			100,SSSSSS1,2004/5/20,FALSE,bean1,987654321,
			108,SSSSSS2,1969/10/10,TRUE,bean2,1234567890,カカ`
			 */
			Object obj = loadedBeans.get(0);
			assertEquals(obj.getClass(), TestBean1.class);
			TestBean1 bean1 = (TestBean1) obj;
			assertEquals(100, bean1.getIntValue());
			assertEquals(987654321, bean1.getLongValue());
			assertEquals(false, bean1.isBooleanValue());
			assertEquals("bean1", bean1.getStringValue());
			assertEquals(
				"2004/05/20",
				format4Assert.format(bean1.getDateValue()));
			assertEquals(TestEnum1.VAL_1, bean1.getEnum1Value());
			//
			obj = loadedBeans.get(1);
			assertEquals(obj.getClass(), TestBean1.class);
			TestBean1 bean2 = (TestBean1) obj;
			assertEquals(108, bean2.getIntValue());
			assertEquals(1234567890, bean2.getLongValue());
			assertEquals(true, bean2.isBooleanValue());
			assertEquals("bean2", bean2.getStringValue());
			assertEquals(
				"1969/10/10",
				format4Assert.format(bean2.getDateValue()));
			assertEquals(TestEnum1.VAL_999, bean2.getEnum1Value());
			//
		} catch (IOException e) {
			e.printStackTrace();
			fail();
			return;
		}

	}

}
