/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/05 6:04:22
 */
package test.org.asyrinx.brownie.core.lang;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.NumberUtils;

/**
 * @author akima
 */
public class NumberUtilsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(NumberUtilsTest.class);
    }

    /*
     * Class under test for int toInt(Object, int)
     */
    public void testToInt() {
        assertEquals(9, NumberUtils.toInt(null, 9));
        assertEquals(9, NumberUtils.toInt(new Byte((byte) 9), 100));
        assertEquals(9, NumberUtils.toInt(new Short((short) 9), 100));
        assertEquals(9, NumberUtils.toInt(new Integer(9), 100));
        assertEquals(9, NumberUtils.toInt(new Long(9), 100));
        assertEquals(9, NumberUtils.toInt(new Float(9), 100));
        assertEquals(9, NumberUtils.toInt(new Double(9), 100));
        assertEquals(9, NumberUtils.toInt("9", 100));
        assertEquals(9, NumberUtils.toInt("09", 100));
        assertEquals(9, NumberUtils.toInt("0009", 100));
    }

    public static void testDropDecimal() {
        assertEquals(0, NumberUtils.dropFractions(0), 0);
        assertEquals(-128, NumberUtils.dropFractions(-128), 0);
        assertEquals(-128, NumberUtils.dropFractions(-128.456), 0);
        assertEquals(-128, NumberUtils.dropFractions(-128.789), 0);
        assertEquals(128, NumberUtils.dropFractions(128), 0);
        assertEquals(128, NumberUtils.dropFractions(128.456), 0);
        assertEquals(128, NumberUtils.dropFractions(128.789), 0);
    }

    public static void testHasDecimal() {
        assertEquals(false, NumberUtils.hasFractions(0));
        assertEquals(false, NumberUtils.hasFractions(-128));
        assertEquals(false, NumberUtils.hasFractions(Double.MAX_VALUE));
        assertEquals(true, NumberUtils.hasFractions(Double.MIN_VALUE));
        assertEquals(true, NumberUtils.hasFractions(0.567));
        assertEquals(true, NumberUtils.hasFractions(-128.567));
        assertEquals(true, NumberUtils.hasFractions(56798.567));
    }

    //memo
    //byte -128ȏ/127ȉ
    //short -32768ȏ/32767ȉ
    // int -2147483648ȏ/2147483647ȉ
    //long -9223372036854775808ȏ/9223372036854775807ȉ
    //float IEEEPx32bit_
    //double IEEE{x64bit_

    public void testGetMinimumClass() {
        assertEquals(Byte.class, NumberUtils.getMinimumClass(-128));
        assertEquals(Byte.class, NumberUtils.getMinimumClass(127));
        assertEquals(Short.class, NumberUtils.getMinimumClass(-129));
        assertEquals(Short.class, NumberUtils.getMinimumClass(128));
        assertEquals(Short.class, NumberUtils.getMinimumClass(-32768));
        assertEquals(Short.class, NumberUtils.getMinimumClass(32767));
        assertEquals(Integer.class, NumberUtils.getMinimumClass(-32769));
        assertEquals(Integer.class, NumberUtils.getMinimumClass(32768));
        assertEquals(Integer.class, NumberUtils.getMinimumClass(-2147483648));
        assertEquals(Integer.class, NumberUtils.getMinimumClass(2147483647));
        assertEquals(Long.class, NumberUtils.getMinimumClass(-2147483649l));
        assertEquals(Long.class, NumberUtils.getMinimumClass(2147483648l));
        assertEquals(Long.class, NumberUtils.getMinimumClass(-9223372036854775808l));
        assertEquals(Long.class, NumberUtils.getMinimumClass(9223372036854775807l));
        //assertEquals(Float.class, NumberUtils.getMinimumClass(3.14));
        //assertEquals(Float.class, NumberUtils.getMinimumClass(-3.14));
        assertEquals(Double.class, NumberUtils.getMinimumClass(3.14));
        assertEquals(Double.class, NumberUtils.getMinimumClass(-3.14));
        assertEquals(Float.class, NumberUtils.getMinimumClass(Float.MIN_VALUE));
        assertEquals(Float.class, NumberUtils.getMinimumClass(-Float.MIN_VALUE));
        assertEquals(Float.class, NumberUtils.getMinimumClass(3.4028235e+30f));
        assertEquals(Float.class, NumberUtils.getMinimumClass(3.4028235e+38f));
        assertEquals(Float.class, NumberUtils.getMinimumClass(-3.4028235e+30f));
        assertEquals(Float.class, NumberUtils.getMinimumClass(-3.4028235e+38f));
        assertEquals(Float.class, NumberUtils.getMinimumClass(Float.MAX_VALUE));
        assertEquals(Float.class, NumberUtils.getMinimumClass(-Float.MAX_VALUE));
        assertEquals(Double.class, NumberUtils.getMinimumClass(-3.141592E-200));
        assertEquals(Double.class, NumberUtils.getMinimumClass(-3.141592E+200));
        assertEquals(Double.class, NumberUtils.getMinimumClass(Double.MIN_VALUE));
        assertEquals(Double.class, NumberUtils.getMinimumClass(Double.MIN_VALUE));
        assertEquals(Double.class, NumberUtils.getMinimumClass(-Double.MIN_VALUE));
        assertEquals(Double.class, NumberUtils.getMinimumClass(-Double.MIN_VALUE));
    }

    public void testGetMinimumClassByClass() {
        assertEquals(Byte.class, NumberUtils.getMaximunClassByClass(null));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByClass(new Number[] {}));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByClass(new Number[] { new Byte((byte) 0) }));
        assertEquals(Short.class, NumberUtils.getMaximunClassByClass(new Number[] { new Short((short) 0) }));
        assertEquals(Integer.class, NumberUtils.getMaximunClassByClass(new Number[] { new Integer(0) }));
        assertEquals(Long.class, NumberUtils.getMaximunClassByClass(new Number[] { new Long(0) }));
        assertEquals(Long.class, NumberUtils.getMaximunClassByClass(new Number[] { new Integer(0), new Byte((byte) 0),
                new Long(0) }));
    }

    public void testGetMinimumClassByValueZero() {
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(null));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] {}));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] { new Byte((byte) 0) }));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] { new Short((short) 0) }));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] { new Integer(0) }));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] { new Long(0) }));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] { new Integer(0), new Byte((byte) 0),
                new Long(0) }));
    }

    public void testGetMinimumClassByValue1() {
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(null));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] {}));
        assertEquals(Byte.class, NumberUtils.getMaximunClassByValue(new Number[] { new Byte((byte) 23) }));
        assertEquals(Short.class, NumberUtils.getMaximunClassByValue(new Number[] { new Short((short) 234) }));
        assertEquals(Integer.class, NumberUtils.getMaximunClassByValue(new Number[] { new Integer(65535) }));
        assertEquals(Long.class, NumberUtils.getMaximunClassByValue(new Number[] { new Long(3147483647L) }));
        assertEquals(Long.class, NumberUtils.getMaximunClassByValue(new Number[] { new Double(65555),
                new Double((byte) 77), new Double(3147483647L), new Double(4997897897L) }));
        assertEquals(Integer.class, NumberUtils.getMaximunClassByValue(new Number[] { new Double(65555),
                new Double((byte) 77), new Double(123456), new Double(9876) }));
        //
        assertEquals(Double.class, NumberUtils.getMaximunClassByValue(new Number[] { new Double(65555),
                new Double((byte) 77), new Double(123456), new Double(9876.98) }));
    }
}