/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/20 13:57:07
 */
package test.org.asyrinx.brownie.core.query;

import java.util.Date;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.query.Select;
import org.asyrinx.brownie.core.query.exp.FieldExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.FieldAlias;
import org.asyrinx.brownie.core.query.model.Table;

/**
 * @author takeshi
 */
public class SelectTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SelectTest.class);
    }

    public static final Table TABLE1 = new Table("table1", "table1");

    public static final Field COLUMN1 = new Field(TABLE1, Long.class, "id", "id");

    public static final Field COLUMN2 = new Field(TABLE1, String.class, "name", "name");

    public static final Field COLUMN3 = new Field(TABLE1, Double.class, "price", "price");

    public static final Field COLUMN4 = new Field(TABLE1, Date.class, "updated", "updated");

    public void testAutoAddFromTableFromFields() {
        final Select select1 = new Select();
        select1.getFields().add(new FieldAlias(COLUMN1));
        select1.getFields().add(new FieldAlias(COLUMN2));
        select1.getFields().add(new FieldAlias(COLUMN3));
        //
        assertEquals(3, select1.getFields().size());
        assertEquals("id", select1.getFields().get(0).getName());
        assertEquals("name", select1.getFields().get(1).getName());
        assertEquals("price", select1.getFields().get(2).getName());
        //
        assertEquals(1, select1.getFroms().size());
        assertEquals("table1", select1.getFroms().get(0).getName());
        assertEquals(TABLE1.alias(), select1.getFroms().get(0));
    }

    public void testAutoAddFromTableFromWhere() {
        final Select select1 = new Select();
        select1.getWhere().add(new FieldExpression(new FieldAlias(COLUMN1, "aid"), IExpression.EQUAL, "789"));
        assertEquals(1, select1.getFroms().size());
        assertEquals("table1", select1.getFroms().get(0).getName());
        assertEquals(TABLE1.alias(), select1.getFroms().get(0));
    }
}