/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package test.org.asyrinx.brownie.core.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.DateUtils;

/**
 * @author akima
 */
public class DateUtilsTest extends TestCase {

    /**
     * Constructor for DateUtilsTest.
     * 
     * @param arg0
     */
    public DateUtilsTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DateUtilsTest.class);
    }

    /*
     * Test for Date toDate(int, int, int)
     */
    public void testToDateintintint() {
        final DateFormat f = new SimpleDateFormat("yyyy/MM/dd");
        assertEquals("2003/05/31", f.format(DateUtils.toDate(2003, 5, 31)));
    }

    /*
     * Test for Date toDate(int, int, int, int, int)
     */
    public void testToDateintintintintint() {
        final DateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        assertEquals("2003/05/31 09:09", f.format(DateUtils.toDate(2003, 5, 31, 9, 9)));
        assertEquals("2003/05/31 23:59", f.format(DateUtils.toDate(2003, 5, 31, 23, 59)));
    }

    /*
     * Test for Date toDate(int, int, int, int, int, int)
     */
    public void testToDateintintintintintint() {
        final DateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        assertEquals("2003/05/31 09:09:09", f.format(DateUtils.toDate(2003, 5, 31, 9, 9, 9)));
        assertEquals("2003/05/31 23:59:59", f.format(DateUtils.toDate(2003, 5, 31, 23, 59, 59)));
    }

    /*
     * Test for Date toDate(int, int, int, int, int, int, int)
     */
    public void testToDateintintintintintintint() {
        final DateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        assertEquals("2003/05/31 09:09:09:009", f.format(DateUtils.toDate(2003, 5, 31, 9, 9, 9, 9)));
        assertEquals("2003/05/31 23:59:59:999", f.format(DateUtils.toDate(2003, 5, 31, 23, 59, 59, 999)));
    }

    public void testGetEndDayOfMonth() {
        assertEquals(31, DateUtils.getLastDayOfMonth(2003, 1));
        assertEquals(28, DateUtils.getLastDayOfMonth(2003, 2));
        assertEquals(31, DateUtils.getLastDayOfMonth(2003, 3));
        assertEquals(30, DateUtils.getLastDayOfMonth(2003, 4));
        assertEquals(31, DateUtils.getLastDayOfMonth(2003, 5));
        assertEquals(30, DateUtils.getLastDayOfMonth(2003, 6));
        assertEquals(31, DateUtils.getLastDayOfMonth(2003, 7));
        assertEquals(31, DateUtils.getLastDayOfMonth(2003, 8));
        assertEquals(30, DateUtils.getLastDayOfMonth(2003, 9));
        assertEquals(31, DateUtils.getLastDayOfMonth(2003, 10));
        assertEquals(30, DateUtils.getLastDayOfMonth(2003, 11));
        assertEquals(31, DateUtils.getLastDayOfMonth(2003, 12));
        //		
        assertEquals(31, DateUtils.getLastDayOfMonth(2004, 1));
        assertEquals(29, DateUtils.getLastDayOfMonth(2004, 2));
        assertEquals(31, DateUtils.getLastDayOfMonth(2004, 3));
        assertEquals(30, DateUtils.getLastDayOfMonth(2004, 4));
        assertEquals(31, DateUtils.getLastDayOfMonth(2004, 5));
        assertEquals(30, DateUtils.getLastDayOfMonth(2004, 6));
        assertEquals(31, DateUtils.getLastDayOfMonth(2004, 7));
        assertEquals(31, DateUtils.getLastDayOfMonth(2004, 8));
        assertEquals(30, DateUtils.getLastDayOfMonth(2004, 9));
        assertEquals(31, DateUtils.getLastDayOfMonth(2004, 10));
        assertEquals(30, DateUtils.getLastDayOfMonth(2004, 11));
        assertEquals(31, DateUtils.getLastDayOfMonth(2004, 12));
    }

    public void testInfinity() {
        final Date d = new Date();
        final Date past = DateUtils.getInfinitePast();
        final Date future = DateUtils.getInfiniteFuture();
        assertEquals(false, past.after(d));
        assertEquals(true, past.before(d));
        assertEquals(true, d.after(past));
        assertEquals(false, d.before(past));
        assertEquals(true, future.after(d));
        assertEquals(false, future.before(d));
        assertEquals(false, d.after(future));
        assertEquals(true, d.before(future));
        //
        assertEquals(false, d.before(d));
        assertEquals(false, d.after(d));
        assertEquals(true, d.equals(d));
        assertEquals(0, d.compareTo(d));
        //
        assertEquals(false, past.before(past));
        assertEquals(false, past.after(past));
        assertEquals(true, past.equals(past));
        assertEquals(0, past.compareTo(past));
        //
        assertEquals(false, future.before(future));
        assertEquals(false, future.after(future));
        assertEquals(true, future.equals(future));
        assertEquals(0, future.compareTo(future));
    }

}