/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/03 0:13:46
 */
package test.org.asyrinx.brownie.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.asyrinx.brownie.core.util.NullableFormat;
import org.asyrinx.brownie.core.util.SimpleDate;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class NullableFormatTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(NullableFormatTest.class);
    }

    /**
     * Constructor for NullableFormatTest.
     * 
     * @param arg0
     */
    public NullableFormatTest(String arg0) {
        super(arg0);
    }

    /*
     * Class under test for Object parseObject(String, ParsePosition)
     */
    public void testParseObjectStringParsePosition() {
        final DateFormat dateFormat1 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        final SimpleDate sd1 = new SimpleDate(2004, 12, 3);
        try {
            dateFormat1.parse(null);
            fail();
        } catch (ParseException e) {
            fail();
        } catch (NullPointerException e) {
            assertTrue(true);
        }
        final NullableFormat nullableFormat = new NullableFormat(dateFormat1);
        nullableFormat.setParseResultWhenNull(sd1);
        try {
            assertEquals(sd1, nullableFormat.parseObject(null));
            assertEquals(sd1.toDateBegin(), nullableFormat.parseObject("2004/12/03 00:00"));
        } catch (ParseException e) {
            e.printStackTrace();
            fail();
            return;
        } catch (NullPointerException e) {
            e.printStackTrace();
            fail();
            return;
        }

    }

    /*
     * Class under test for StringBuffer format(Object, StringBuffer,
     * FieldPosition)
     */
    public void testFormatObjectStringBufferFieldPosition() {
        final DateFormat dateFormat1 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        final Date date1;
        try {
            date1 = dateFormat1.parse("2004/12/03 0:24");
        } catch (ParseException e1) {
            e1.printStackTrace();
            fail();
            return;
        }
        try {
            dateFormat1.format(null);
            fail();
        } catch (NullPointerException e) {
            assertTrue(true);
        }
        final NullableFormat nullableFormat = new NullableFormat(dateFormat1);
        nullableFormat.setFormatResultWhenNull("");
        try {
            assertEquals("", nullableFormat.format(null));
            assertEquals("2004/12/03 00:24", nullableFormat.format(date1));
        } catch (NullPointerException e) {
            e.printStackTrace();
            fail();
            return;
        }
    }

}