/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 4:34:39
 */
package test.org.asyrinx.brownie.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.util.NumberComparator;

/**
 * @author akima
 */
public class NumberComparatorTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(NumberComparatorTest.class);
    }

    public void testCompare1() {
        assertEquals(-1, "0".compareTo("1"));
        assertEquals(1, "1".compareTo("0"));
        assertEquals(0, "1".compareTo("1"));
        //OK
        assertEquals(-1, new Integer(0).compareTo(new Integer(1)));
        try {
            //Number̔hNX͓NX̃CX^XmȂComparełȂ
            assertEquals(-1, new Integer(0).compareTo(new Long(1)));
            fail();
        } catch (ClassCastException e) {
            //OK!
        }
        final Comparator comparator = new NumberComparator();
        final Integer i0 = new Integer(0);
        final Integer i1 = new Integer(1);
        final Long l0 = new Long(0);
        final Long l1 = new Long(1);
        final Float f0 = new Float(0);
        final Float f1 = new Float(1);
        assertEquals(0, comparator.compare(i0, i0));
        assertEquals(-1, comparator.compare(i0, i1));
        assertEquals(1, comparator.compare(i1, i0));
        //
        assertEquals(0, comparator.compare(i0, l0));
        assertEquals(-1, comparator.compare(i0, l1));
        assertEquals(1, comparator.compare(i1, l0));
        assertEquals(0, comparator.compare(i0, f0));
        assertEquals(-1, comparator.compare(i0, f1));
        assertEquals(1, comparator.compare(i1, f0));
    }

    private Number[] newNumberArray(Class numberClass) {
        final Number[] result = new Number[Byte.MAX_VALUE - Byte.MIN_VALUE + 1];
        for (int i = 0; i < result.length; i++) {
            final String value = String.valueOf(i + Byte.MIN_VALUE);
            try {
                result[i] = (Number) ClassUtils.newObject(numberClass, Number.class, new Object[] { value });
            } catch (InstantiationException e) {
                System.out.println("result.length=" + result.length + "  i=" + i);
                System.out.println("class=" + numberClass.getName() + "  value=" + value);
                e.printStackTrace();
                fail();
                return null;
            }
        }
        return result;
    }

    public void testCompare2() {
        final Comparator comparator = new NumberComparator();
        final Number[][] numbers = new Number[][] { newNumberArray(Byte.class), newNumberArray(Short.class),
                newNumberArray(Integer.class), newNumberArray(Long.class), newNumberArray(Float.class),
                newNumberArray(Double.class), };
        for (int i = 0; i < numbers.length; i++) {
            final Number[] na1 = numbers[i];
            for (int j = 0; j < numbers.length; j++) {
                if (i == j)
                    continue;
                final Number[] na2 = numbers[i];
                for (int k1 = 0; k1 < na1.length; k1++) {
                    for (int k2 = 0; k2 < na2.length; k2++) {
                        assertEquals(k1 < k2, comparator.compare(na1[k1], na2[k2]) < 0);
                        assertEquals(k1 > k2, comparator.compare(na2[k2], na1[k1]) < 0);
                        assertEquals(k1 == k2, comparator.compare(na1[k1], na2[k2]) == 0);
                        assertEquals(k1 == k2, comparator.compare(na2[k2], na1[k1]) == 0);
                    }
                }
            }
        }
    }

    public void testCompareOnList() {
        final Comparator comparator = new NumberComparator();
        //
        final List list = new ArrayList();
        list.add(new Byte((byte) 100));
        list.add(new Integer(1000));
        list.add(new Long(98765434567L));
        list.add(new Integer(-5000));
        list.add(new Short((short) (Byte.MAX_VALUE + 100)));
        list.add(new Byte((byte) -50));
        list.add(new Short((short) (Byte.MIN_VALUE - 100)));
        list.add(new Long(-8765456));
        list.add(new Float(100.456789f));
        list.add(new Float(-87645.45f));
        list.add(new Double(987645.12345));
        list.add(new Double(-0.0912345));
        Collections.sort(list, comparator);
        //System.out.println(list);
        assertEquals(12, list.size());
        assertEquals(-8765456, toLong(list, 0));
        assertEquals(-87645.45f, toDouble(list, 1), 0);
        assertEquals(-5000, toLong(list, 2));
        assertEquals(Byte.MIN_VALUE - 100, toLong(list, 3));
        assertEquals(-50, toLong(list, 4));
        assertEquals(-0.0912345, toDouble(list, 5), 0);
        assertEquals(100, toLong(list, 6));
        assertEquals(100.456789f, toDouble(list, 7), 0);
        assertEquals(Byte.MAX_VALUE + 100, toLong(list, 8));
        assertEquals(1000, toLong(list, 9));
        assertEquals(987645.12345, toDouble(list, 10), 0);
        assertEquals(98765434567L, toLong(list, 11));
    }

    private long toLong(List list, int index) {
        return ((Number) list.get(index)).longValue();
    }

    private double toDouble(List list, int index) {
        return ((Number) list.get(index)).doubleValue();
    }

    public void testCompareOnList1() {
        final NumberComparator comparator = new NumberComparator();
        //
        final List list = new ArrayList();
        list.add(new Integer(1000));
        list.add(null);
        list.add("345");
        list.add("abc");
        list.add("def");
        list.add(new Integer(-5000));
        list.add(new Integer(100));
        list.add(null);
        //{̃\[g
        comparator.setSortType(NumberComparator.NULL_NUM_STR);
        comparator.setInverseNumber(false);
        comparator.setInverseString(false);
        Collections.sort(list, comparator);
        checkList(list, new String[] { null, null, "-5000", "100", "345", "1000", "abc", "def", });
        //lt\[g
        comparator.setSortType(NumberComparator.NULL_NUM_STR);
        comparator.setInverseNumber(true);
        Collections.sort(list, comparator);
        checkList(list, new String[] { null, null, "1000", "345", "100", "-5000", "abc", "def", });
        //t\[g
        comparator.setSortType(NumberComparator.NULL_NUM_STR);
        comparator.setInverseNumber(false);
        comparator.setInverseString(true);
        Collections.sort(list, comparator);
        checkList(list, new String[] { null, null, "-5000", "100", "345", "1000", "def", "abc", });
        //
        comparator.setInverseNumber(false);
        comparator.setInverseString(false);
        //nullAAl
        comparator.setSortType(NumberComparator.NULL_STR_NUM);
        Collections.sort(list, comparator);
        checkList(list, new String[] { null, null, "abc", "def", "-5000", "100", "345", "1000", });
        //lAAnull
        comparator.setSortType(NumberComparator.NUM_STR_NULL);
        Collections.sort(list, comparator);
        checkList(list, new String[] { "-5000", "100", "345", "1000", "abc", "def", null, null, });
        //lAnullA
        comparator.setSortType(NumberComparator.NUM_NULL_STR);
        Collections.sort(list, comparator);
        checkList(list, new String[] { "-5000", "100", "345", "1000", null, null, "abc", "def", });
    }

    public void checkList(List list, String[] expected) {
        assertEquals(expected.length, list.size());
        for (int i = 0; i < expected.length; i++) {
            if (expected[i] == null)
                assertEquals(null, list.get(i));
            else
                assertEquals(expected[i], String.valueOf(list.get(i)));
        }
    }

}