/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/11/04
 */
package test.org.asyrinx.brownie.core.xml.digester;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.xml.digester.AsyrinxDigester;
import org.xml.sax.SAXException;

/**
 * @author akima
 */
public class ActionMapBuilderTest extends TestCase {

    /**
     * Constructor for ActionMapBuilderTest.
     * 
     * @param name
     */
    public ActionMapBuilderTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ActionMapBuilderTest.class);
    }

    public void testExecute() {
        //BasicConfigurator.configure();
        /*
         * <actionMap> <actions> <action name="act1"
         * class="test.org.asyrinx.servlet.action." /> </actions> </actionMap>
         */
        final StringBuffer b = new StringBuffer();
        b.append("<actionMap>");
        b.append("<actions>");
        b.append("<action name=\"act1\" caption=\"action No.1\" class=\"" + Action1.class.getName() + "\" >");
        b.append("<option name=\"opt3\" value=\"value_opt3\" />");
        b.append("<option name=\"opt4\" value=\"value_opt4\" />");
        b.append("<option name=\"opt5\" value=\"value_opt5\" />");
        b.append("</action>");
        b.append("<action name=\"act2\" caption=\"action No.2\" class=\"" + Action2.class.getName() + "\" >");
        b.append("<option name=\"opt1\" value=\"value_opt1\" />");
        b.append("<option name=\"opt2\" value=\"value_opt2\" />");
        b.append("</action>");
        b.append("</actions>");
        b.append("</actionMap>");

        //System.out.println(b.toString());

        final TestBuilder builder = new TestBuilder(new ByteArrayInputStream(b.toString().getBytes()));

        try {
            builder.execute();
            final Object object = builder.getResult();
            assertTrue(object instanceof ActionMap);
            final ActionMap actionMap = (ActionMap) object;
            assertNotNull(actionMap.getActions());
            assertEquals(2, actionMap.getActions().size());
            assertEquals("act1", actionMap.getActions().get(0).getName());
            assertEquals("action No.1", actionMap.getActions().get(0).getCaption());
            assertEquals(Action1.class, actionMap.getActions().get(0).getClass());
            assertEquals(3, actionMap.getActions().get(0).getOptions().keySet().size());
            assertEquals("value_opt3", actionMap.getActions().get(0).getOptions().getProperty("opt3"));
            assertEquals("value_opt4", actionMap.getActions().get(0).getOptions().getProperty("opt4"));
            assertEquals("value_opt5", actionMap.getActions().get(0).getOptions().getProperty("opt5"));

            assertEquals("act2", actionMap.getActions().get(1).getName());
            assertEquals("action No.2", actionMap.getActions().get(1).getCaption());
            assertEquals(Action2.class, actionMap.getActions().get(1).getClass());
            assertEquals(2, actionMap.getActions().get(1).getOptions().keySet().size());
            assertEquals("value_opt1", actionMap.getActions().get(1).getOptions().getProperty("opt1"));
            assertEquals("value_opt2", actionMap.getActions().get(1).getOptions().getProperty("opt2"));
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

    public static class TestBuilder {

        public void execute() throws IOException, SAXException {
            final AsyrinxDigester d = new AsyrinxDigester();
            d.setValidating(false);

            d.addRoot("actionMap", ActionMap.class);
            d.addProp("actionMap/actions", Actions.class, "actions");
            d.addProps("actionMap/actions/action", Action.class);
            d.addCallMethod("actionMap/actions/action/option", "addOption", new Class[] { String.class, String.class },
                    new String[] { "name", "value" });
            /*
             * d.addCallMethod( "actionMap/actions/action/option", "addOption",
             * 2, new Class[] { String.class, String.class });
             * d.addCallParam("actionMap/actions/action/option", 0, "name");
             * d.addCallParam("actionMap/actions/action/option", 1, "value");
             */

            result = d.parse(getSourceStream());
        }

        /**
         * Constructor for ActionMapBuilder.
         */
        public TestBuilder(InputStream sourceStream) {
            super();
            this.sourceStream = sourceStream;
        }

        private Object result = null;

        private final InputStream sourceStream;

        public InputStream getSourceStream() {
            return sourceStream;
        }

        /**
         * @return
         */
        public Object getResult() {
            return result;
        }

    }

    public static class ActionMap {
        public ActionMap() {
            super();
        }

        private Actions actions = null;

        public Actions getActions() {
            return actions;
        }

        public void setActions(Actions actions) {
            this.actions = actions;
        }

    }

    public static class Actions {
        public Actions() {
            super();
        }

        private final List actionList = new ArrayList();

        /**
         * @param index
         * @param element
         */
        public void add(Action element) {
            actionList.add(element);
        }

        /**
         *  
         */
        public void clear() {
            actionList.clear();
        }

        /**
         * @param index
         * @return
         */
        public Action get(int index) {
            return (Action) actionList.get(index);
        }

        /**
         * @param o
         * @return
         */
        public int indexOf(Action o) {
            return actionList.indexOf(o);
        }

        /**
         * @return
         */
        public boolean isEmpty() {
            return actionList.isEmpty();
        }

        /**
         * @return
         */
        public Iterator iterator() {
            return actionList.iterator();
        }

        /**
         * @param o
         * @return
         */
        public boolean remove(Action o) {
            return actionList.remove(o);
        }

        /**
         * @return
         */
        public int size() {
            return actionList.size();
        }
    }

    public static class Action {
        public Action() {
            super();
        }

        private String name = null;

        private String caption = null;

        /**
         * @return
         */
        public String getName() {
            return name;
        }

        /**
         * @param string
         */
        public void setName(String string) {
            name = string;
        }

        /**
         * @return
         */
        public String getCaption() {
            return caption;
        }

        /**
         * @param string
         */
        public void setCaption(String string) {
            caption = string;
        }

        final Properties options = new Properties();

        public void addOption(String optionName, String value) {
            options.setProperty(optionName, value);
        }

        public Properties getOptions() {
            return options;
        }

    }

    public static class Action1 extends Action {
        public Action1() {
            super();
        }
    }

    public static class Action2 extends Action {
        public Action2() {
            super();
        }
    }

}