/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/26 6:18:22
 */
package test.org.asyrinx.brownie.pdf.fop.impl;

import java.io.FileOutputStream;
import java.io.IOException;

import org.asyrinx.brownie.core.xml.dom.DomBuilder;
import org.asyrinx.brownie.core.xml.dom.XmlBeanWriter;
import org.asyrinx.brownie.core.xml.dom.impl.DomBuilderNode;
import org.asyrinx.brownie.core.xml.dom.impl.XmlBeanWriterImpl;
import org.asyrinx.brownie.pdf.fop.PdfException;
import org.asyrinx.brownie.pdf.fop.PdfMaker;
import org.asyrinx.brownie.pdf.fop.impl.FopInvokerImpl;
import org.asyrinx.brownie.pdf.fop.impl.PdfMakerImpl;

/**
 * @author takeshi
 */
public class FopSample {

    /**
     *  
     */
    public FopSample() {
        super();
    }

    public static void main(String[] args) {
        try {
            new FopSample().execute();
        } catch (PdfException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void execute() throws PdfException, IOException {
        final String dir = "D:/dev/asyrinx.org/local/brownies/src/test/test/org/asyrinx/brownie/pdf/fop/impl";

        final Object bean = new SampleBeanBuilder().build();
        final FopInvokerImpl fopInvoker = new FopInvokerImpl();
        fopInvoker.setConfig(dir + "/userconfig.xml");
        final DomBuilder domBuilder = new DomBuilderNode();
        final XmlBeanWriter xmlBeanWriter = new XmlBeanWriterImpl(domBuilder);
        final PdfMaker pdfMaker = new PdfMakerImpl(fopInvoker, xmlBeanWriter);
        final FileOutputStream domout1 = new FileOutputStream(dir + "/party7123.xml");
        pdfMaker.setDomOutput(domout1); //wlk֏o͂ꍇ̂ݎgp
        final FileOutputStream dest = new FileOutputStream(dir + "/party7123.pdf");
        pdfMaker.execute(bean, "test/org/asyrinx/brownie/pdf/fop/impl/party-fo.xsl", dest, "party");
        domout1.flush();
        domout1.close();
        dest.flush();
        dest.close();
        System.out.println("success!");
    }
}