/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/12 16:35:22
 */
package test.org.asyrinx.brownie.seasar.aop;

import org.asyrinx.brownie.seasar.aop.CacheInterceptor;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class CacheInterceptorTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CacheInterceptorTest.class);
    }

    static int invokedCount = 0;

    public static class MathCalc {
        public int getFactorial(int value) {
            invokedCount++;
            int result = 1;
            for (int i = 1; i <= value; i++)
                result = result * i;
            return result;
        }

        public int getFibonacci(int value) {
            invokedCount++;
            if (value < 3)
                return 1;
            int result = 0;
            int x_1 = 1;
            int x_2 = 1;
            for (int i = 3; i <= value; i++) {
                result = x_1 + x_2;
                x_1 = x_2;
                x_2 = result;
            }
            return result;
        }

        public int getArithmeticalProgressionSequence(int firstTerm, int difference, int n) {
            invokedCount++;
            return firstTerm + difference * n; //0 originŌvZ
        }

        public void doNothing() {
            invokedCount++;
        }

        public void doNothing(String value) {
            invokedCount++;
        }

    }

    public void testInvoke() {
        invokedCount = 0;
        final CacheInterceptor cacheInterceptor = new CacheInterceptor();
        final MathCalc target = (MathCalc) cacheInterceptor.createProxy(MathCalc.class);
        assertEquals(0, invokedCount);
        assertEquals(120, target.getFactorial(5));
        assertEquals(1, invokedCount);
        assertEquals(120, target.getFactorial(5));
        assertEquals(1, invokedCount);
        assertEquals(720, target.getFactorial(6));
        assertEquals(2, invokedCount);
        assertEquals(720, target.getFactorial(6));
        assertEquals(2, invokedCount);
        //
        assertEquals(5, target.getFibonacci(5));
        assertEquals(3, invokedCount);
        assertEquals(5, target.getFibonacci(5));
        assertEquals(3, invokedCount);
        assertEquals(8, target.getFibonacci(6));
        assertEquals(4, invokedCount);
        assertEquals(8, target.getFibonacci(6));
        assertEquals(4, invokedCount);
        //
        assertEquals(20, target.getArithmeticalProgressionSequence(20, 3, 0));
        assertEquals(5, invokedCount);
        assertEquals(20, target.getArithmeticalProgressionSequence(20, 3, 0));
        assertEquals(5, invokedCount);
        assertEquals(35, target.getArithmeticalProgressionSequence(20, 3, 5));
        assertEquals(6, invokedCount);
        assertEquals(35, target.getArithmeticalProgressionSequence(20, 3, 5));
        assertEquals(6, invokedCount);
        //
        target.doNothing();
        assertEquals(7, invokedCount);
        target.doNothing();
        assertEquals(7, invokedCount);
        target.doNothing("aaaa");
        assertEquals(8, invokedCount);
        target.doNothing("aaaa");
        assertEquals(8, invokedCount);
        target.doNothing("bbbb");
        assertEquals(9, invokedCount);
    }

}