/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 17:36:38
 */
package org.asyrinx.brownie.core.chars.impl;

import org.asyrinx.brownie.core.chars.Characters;

/**
 * @author takeshi
 */
public class CharRangeCharacters implements Characters {

    /**
     *  
     */
    public CharRangeCharacters(String name, char low, char high) {
        super();
        this.name = name;
        this.low = low;
        this.high = high;
    }

    private final String name;

    private final char low;

    private final char high;

    public String getName() {
        return name;
    }

    public boolean contains(char c) {
        return (low <= c) && (c <= high);
    }

    public String expandToString() {
        final StringBuffer result = new StringBuffer();
        for (char i = low; i <= high; i++) {
            result.append(i);
        }
        return result.toString();
    }
}