/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 17:33:08
 */
package org.asyrinx.brownie.core.chars.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.core.chars.CharactersDictionary;
import org.asyrinx.brownie.core.chars.CharactersExpressionParser;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.text.EscapedStringSplitter;

/**
 * @author takeshi
 */
public class CharactersExpressionParserImpl implements CharactersExpressionParser {

    /**
     *  
     */
    public CharactersExpressionParserImpl(CharactersDictionary dictionary) {
        super();
        this.dictionary = dictionary;
    }

    private String stringCharacterSetBegin = "[[";

    private String stringCharacterSetEnd = "]]";

    private final CharactersDictionary dictionary;

    public Characters[] parse(String expression) {
        final List keys = parseToKeys(expression);
        final List result = new ArrayList();
        for (Iterator i = keys.iterator(); i.hasNext();) {
            final String key = (String) i.next();
            if (StringUtils.isEmpty(key))
                continue;
            if (isStringCharacterSetKey(key)) {
                result.add(new StringCharacters(key, key));
            } else {
                result.add(dictionary.get(key));
            }
        }
        return (Characters[]) result.toArray(new Characters[0]);
    }

    public Characters parseToComposite(String expression) {
        final Characters[] characterSets = parse(expression);
        if (characterSets.length < 1)
            return null;
        if (characterSets.length == 1)
            return characterSets[0];
        return new CompositeCharacters(null, characterSets);
    }

    public Characters parseToComposite(String expression, String name) {
        final Characters[] characterSets = parse(expression);
        return new CompositeCharacters(name, characterSets);
    }

    private boolean isStringCharacterSetKey(final String key) {
        return key.startsWith(getStringCharacterSetBegin())
                && key.endsWith(getStringCharacterSetEnd());
    }

    /**
     * @param expression
     * @return
     */
    private List parseToKeys(String expression) {
        final List result = new ArrayList();
        final EscapedStringSplitter splitter = new EscapedStringSplitter(',', '\\');
        splitter.execute(expression, result);
        return result;
    }

    public String getStringCharacterSetBegin() {
        return stringCharacterSetBegin;
    }

    public void setStringCharacterSetBegin(String stringCharacterSetBegin) {
        this.stringCharacterSetBegin = stringCharacterSetBegin;
    }

    public String getStringCharacterSetEnd() {
        return stringCharacterSetEnd;
    }

    public void setStringCharacterSetEnd(String stringCharacterSetEnd) {
        this.stringCharacterSetEnd = stringCharacterSetEnd;
    }
}