/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/20 14:42:35
 */
package org.asyrinx.brownie.core.csv;

import java.io.IOException;
import java.io.Reader;

/**
 * @author akima
 */
public interface SVParser {

	public abstract void parse(Reader reader) throws IOException;

	public void addListener(SVParserListener listener);

	public void removeListener(SVParserListener listener);

	/** p: char^̋󕶎 */
	public static final char QUOTE_EMPTY = '\u0000';

	/** p: char^̃_uNH[e[V */
	public static final char QUOTE_DOUBLE = '"';

	/** p: char^̃VONH[e[V */
	public static final char QUOTE_SINGLE = '\'';

	/** ؂蕶: J} */
	public static final char DELIM_COMMA = ',';

	/** ؂蕶: ^u */
	public static final char DELIM_TAB = '\t';

}