/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/20 21:18:47
 */
package org.asyrinx.brownie.core.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * @author takeshi
 */
public class MethodUtils extends org.apache.commons.beanutils.MethodUtils {

    public static Object invokeStaticMethod(Class clazz, String methodName, Object[] args)
            throws NoSuchMethodException, IllegalAccessException,
            InvocationTargetException {
        int arguments = args.length;
        Class parameterTypes[] = new Class[arguments];
        for (int i = 0; i < arguments; i++) {
            parameterTypes[i] = args[i].getClass();
        }
        return invokeStaticMethod(clazz, methodName, args, parameterTypes);
    }

    public static Object invokeStaticMethod(Class clazz, String methodName, Object[] args,
            Class[] parameterTypes) throws NoSuchMethodException, 
            IllegalAccessException, InvocationTargetException {
        final Method method = clazz.getMethod(methodName, parameterTypes);
        return method.invoke(null, args);
    }

}