/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/30
 */
package org.asyrinx.brownie.core.lang;

import java.util.HashMap;
import java.util.Map;

/**
 * @author akima
 */
public class NumberUtils extends org.apache.commons.lang.math.NumberUtils {

    //memo
    //byte -128ȏ/127ȉ
    //short -32768ȏ/32767ȉ
    // int -2147483648ȏ/2147483647ȉ
    //long -9223372036854775808ȏ/9223372036854775807ȉ
    //float IEEEPx32bit_
    //double IEEE{x64bit_

    /**
     * ̒̐ȊO폜int^ɕϊĕԂ܂B
     * <P>
     * ϊɎsƂdefaultValueԂ܂B
     * 
     * @param value
     *            
     * @param defaultValue
     *            ϊɎsƂɕԂ
     * @return ϊ̐
     */
    static public int toInt(Object value, int defaultValue) {
        if (value instanceof Number)
            return ((Number) value).intValue();
        try {
            return Integer.parseInt(String.valueOf(value));
        } catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    /**
     * ̒̐ȊO폜double^ɕϊĕԂ܂B
     * <P>
     * ϊɎsƂdefaultValueԂ܂B
     * 
     * @param value
     *            
     * @param defaultValue
     *            ϊɎsƂɕԂdouble
     * @return ϊdouble
     */
    public static double toDouble(Object value, double defaultValue) {
        if (value instanceof Number)
            return ((Number) value).doubleValue();
        try {
            return Double.parseDouble(String.valueOf(value));
        } catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    /**
     * ̒̐ȊO폜long^ɕϊĕԂ܂B
     * <P>
     * ϊɎsƂdefaultValueԂ܂B
     * 
     * @param value
     *            
     * @param defaultValue
     *            ϊɎsƂɕԂlong
     * @return ϊlong
     */
    public static long toLong(Object value, long defaultValue) {
        if (value instanceof Number)
            return ((Number) value).longValue();
        try {
            return Long.parseLong(String.valueOf(value));
        } catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean hasFractions(double value) {
        final double f = dropFractions(value);
        return Double.doubleToLongBits(value) != Double.doubleToLongBits(f);
    }

    public static double dropFractions(double value) {
        return (value < 0) ? Math.ceil(value) : Math.floor(value);
    }

    public static Class getMinimumClass(double value) {
        if (value == 0.0)
            return Byte.class;
        if (hasFractions(value)) {
            value = Math.abs(value);
            final float floatValue = new Double(value).floatValue();
            if (floatValue == 0.0)
                return Double.class;
            if ((Double.compare(Float.MAX_VALUE, value) >= 0) && (Math.abs(value - floatValue) < Float.MIN_VALUE))
                return Float.class;
        } else {
            if ((Byte.MIN_VALUE <= value) && (value <= Byte.MAX_VALUE))
                return Byte.class;
            if ((Short.MIN_VALUE <= value) && (value <= Short.MAX_VALUE))
                return Short.class;
            if ((Integer.MIN_VALUE <= value) && (value <= Integer.MAX_VALUE))
                return Integer.class;
            if ((Long.MIN_VALUE <= value) && (value <= Long.MAX_VALUE))
                return Long.class;
            value = Math.abs(value);
            if (Float.MAX_VALUE >= value)
                return Float.class;
        }
        return Double.class;
    }

    public static Number toMinimunNumberObject(double value) {
        return toMinimunNumberObject(new Double(value));
    }

    public static Number toMinimunNumberObject(Number value) {
        final Class numberClass = getMinimumClass(value.doubleValue());
        if (numberClass == Byte.class)
            return new Byte(value.byteValue());
        if (numberClass == Short.class)
            return new Short(value.shortValue());
        if (numberClass == Integer.class)
            return new Integer(value.intValue());
        if (numberClass == Long.class)
            return new Long(value.longValue());
        if (numberClass == Float.class)
            return new Float(value.floatValue());
        if (numberClass == Double.class)
            return new Double(value.doubleValue());
        return value;
    }

    private static final Map numberClassValues = initNumberClassValues();

    private static Map initNumberClassValues() {
        final Map result = new HashMap() {
            final Object defaultValue = new Integer(0);

            public Object get(Object key) {
                final Object r = super.get(key);
                return (r == null) ? defaultValue : r;
            }
        };
        result.put(Byte.class, new Integer(1));
        result.put(Short.class, new Integer(2));
        result.put(Integer.class, new Integer(3));
        result.put(Long.class, new Integer(4));
        result.put(Float.class, new Integer(11));
        result.put(Double.class, new Integer(12));
        return result;
    }

    private static Class maxClass(Class class1, Class class2) {
        final Integer val1 = (Integer) numberClassValues.get(class1);
        final Integer val2 = (Integer) numberClassValues.get(class2);
        return (val1.intValue() > val2.intValue()) ? class1 : class2;
    }

    public static Class getMaximunClassByClass(Number[] numbers) {
        Class result = Byte.class;
        if (numbers != null)
            for (int i = 0; i < numbers.length; i++) {
                Number number = numbers[i];
                result = maxClass(result, number.getClass());
            }
        return result;
    }

    public static Class getMaximunClassByValue(Number[] numbers) {
        Class result = Byte.class;
        if (numbers != null)
            for (int i = 0; i < numbers.length; i++) {
                Class numberClass = getMinimumClass(numbers[i].doubleValue());
                result = maxClass(result, numberClass);
            }
        return result;
    }

    public static Number toNumber(Object value) {
        return (value instanceof Number) ? (Number) value : NumberUtils.createNumber(String.valueOf(value));
    }

    public static boolean isNumber(Object value) {
        if (value == null)
            return false;
        if (value instanceof Number)
            return true;
        return org.apache.commons.lang.math.NumberUtils.isNumber(String.valueOf(value));
    }

    /**
     * @param value
     * @param resultClass
     * @return
     */
    public static Number toNumber(Object value, Class resultClass) {
        final Number original = toNumber(value);
        if (resultClass == original.getClass()) {
            return original;
        } else {
            if (resultClass == Byte.class)
                return new Byte(original.byteValue());
            else if (resultClass == Short.class)
                return new Short(original.shortValue());
            else if (resultClass == Integer.class)
                return new Integer(original.intValue());
            else if (resultClass == Long.class)
                return new Long(original.longValue());
            else if (resultClass == Float.class)
                return new Float(original.floatValue());
            else if (resultClass == Double.class)
                return new Double(original.doubleValue());
            else
                throw new UnsupportedOperationException("unsupported java.lang.Number sub class: " + resultClass.getName());
        }
    }

}