/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/25 19:00:39
 */
package org.asyrinx.brownie.core.lang.enum.util;

import java.util.List;

import org.apache.commons.lang.enum.Enum;
import org.asyrinx.brownie.core.lang.enum.ValuedEnum;

/**
 * @author takeshi
 */
public class BooleanEnum extends ValuedEnum {

    /**
     * @param name
     * @param value
     */
    public BooleanEnum(int value, boolean booleanValue, String name) {
        super(name, new Integer(value));
        this.boolValue = booleanValue;
    }

    private final boolean boolValue;

    public static final BooleanEnum FALSE = new BooleanEnum(0, false, "false");

    public static final BooleanEnum TRUE = new BooleanEnum(1, true, "true");

    public boolean booleanValue() {
        return boolValue;
    }

    public int intValue() {
        return ((Integer) getValue()).intValue();
    }

    public int asInt() {
        return intValue();
    }

    public static boolean toBoolean(int value) {
        return (value == 0) ? false : true;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static BooleanEnum get(int value) {
        return get(toBoolean(value));
    }

    public static BooleanEnum get(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static List getList() {
        return Enum.getEnumList(BooleanEnum.class);
    }
}