/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/19 17:11:25
 */
package org.asyrinx.brownie.core.query.exp;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.FieldAlias;

/**
 * @author takeshi
 */
public class FieldExpression extends AbstractValuedExpression implements IFieldValuedExpression {

    /**
     *  
     */
    public FieldExpression() {
        super();
    }

    public FieldExpression(FieldAlias fieldAlias, String operator, Object value) {
        super(operator, value);
        this.field = fieldAlias;
    }

    public FieldExpression(Field field, String operator, Object value) {
        super(operator, value);
        this.field = field.alias(field.getAliasName());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.AbstractValuedExpression#fieldAsObject()
     */
    public Object getFieldAsObject() {
        return getField();
    }

    private FieldAlias field;

    /**
     * @return Returns the field.
     */
    public FieldAlias getField() {
        return field;
    }

    /**
     * @param field
     *            The field to set.
     */
    public void setField(FieldAlias field) {
        this.field = field;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.exp.AbstractValuedExpression#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!super.equals(obj))
            return false;
        if (!(obj instanceof IFieldValuedExpression))
            return false;
        final IFieldValuedExpression other = (IFieldValuedExpression) obj;
        return new EqualsBuilder().append(this.getField(), other.getField()).isEquals();
    }

}