/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/20 0:11:21
 */
package org.asyrinx.brownie.core.query.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * @author takeshi
 */
public class TableAlias {

    /**
     *  
     */
    public TableAlias(Table original, String rdbName) {
        super();
        this.original = original;
        this.name = rdbName;
    }

    private final Table original;

    /**
     * @return Returns the original.
     */
    public Table getOriginal() {
        return original;
    }

    private String name;

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.ITable#iterator()
     */
    public Iterator iterator() {
        return original.iterator();
    }

    private final Map fields = new HashMap();

    public FieldAlias getField(Field field) {
        return this.getField(field, field.getAliasName());
    }

    public FieldAlias getField(Field field, String fieldAliasName) {
        final FieldAlias fa = (FieldAlias) fields.get(fieldAliasName);
        if (fa != null)
            return fa;
        final FieldAlias result = new FieldAlias(this, field, fieldAliasName);
        fields.put(fieldAliasName, result);
        return result;
    }

}