/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 13:44:14
 */
package org.asyrinx.brownie.core.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.MessageResourceRuntimeException;

/**
 * @author takeshi
 */
public class PropertiesMessageResource implements MessageResource {

    /**
     *  
     */
    public PropertiesMessageResource(String filePath) {
        this(filePath, StreamFactoryFacade.newFacade());
    }

    /**
     *  
     */
    public PropertiesMessageResource(String filePath, StreamFactory streamFactory) {
        super();
        this.filePath = filePath;
        this.streamFactory = streamFactory;
    }

    public String getBase() {
        return this.filePath;
    }

    protected final String filePath;

    protected final StreamFactory streamFactory;

    private Properties properties = null;

    public String getMessage(String key) {
        if (properties == null) {
            try {
                this.properties = createProperties();
            } catch (IOException e) {
                throw new MessageResourceRuntimeException("failed to load properties.", this.filePath, key, e);
            }
        }
        final String result = this.properties.getProperty(key);
        if (result == null)
            throw new MessageResourceRuntimeException("message not found.", this.filePath, key);
        return result;
    }

    /**
     * @throws IOException
     *  
     */
    private Properties createProperties() throws IOException {
        final Properties result = new Properties();
        final InputStream stream = createStream();
        result.load(stream);
        return result;
    }

    /**
     * @return
     * @throws IOException
     */
    private InputStream createStream() throws IOException {
        return this.streamFactory.newInput(this.filePath);
    }

}