/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 13:34:29
 */
package org.asyrinx.brownie.core.resource.impl;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.MessageResourceRuntimeException;

/**
 * @author takeshi
 */
public class ResourceBundleMessageResource implements MessageResource {

    /**
     *  
     */
    public ResourceBundleMessageResource(String path) {
        this(path, Locale.getDefault());
    }

    /**
     *  
     */
    public ResourceBundleMessageResource(String path, Locale locale) {
        super();
        this.path = path;
        this.locale = locale;
    }

    protected final Locale locale;

    protected final String path;

    public String getBase() {
        return path;
    }

    public String getMessage(String key) {
        final ResourceBundle bundle = ResourceBundle.getBundle(this.path, locale);
        try {
            return bundle.getString(key);
        } catch (MissingResourceException e) {
            throw new MessageResourceRuntimeException("Can't find resource key=" + key + " path="
                    + this.path, this.path, key, e);
        }
    }
}