package org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;

/**
 * t݂̂\NXłB month͕K1n܂12ŏI܂B0͂܂B
 * 
 * @author akima
 */
public final class SimpleDate {

	private final int year;

	private final int month;

	private final int day;

	/**
	 *  
	 */
	public SimpleDate(int year, int month, int day) {
		super();
		this.year = year;
		this.month = month;
		this.day = day;
	}

	/**
	 *  
	 */
	public SimpleDate(Date d) {
		this(d, Calendar.getInstance());
	}

	/**
	 *  
	 */
	public SimpleDate(Date d, Calendar calendar) {
		super();
		calendar.setTime(d);
		this.year = calendar.get(Calendar.YEAR);
		this.month = calendar.get(Calendar.MONTH) + 1;
		this.day = calendar.get(Calendar.DAY_OF_MONTH);
	}

	/**
	 * @return
	 */
	public Date toDate() {
		return toDateBegin();
	}

	/**
	 * @return
	 */
	public Date toDateBegin() {
		return DateUtils.toDate(year, month, day, 0, 0, 0, 0);
	}

	/**
	 * @return
	 */
	public Date toDateEnd() {
		return DateUtils.toDate(year, month, day, 23, 59, 59, 999);
	}

	/**
	 * @param obj
	 * @return @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof SimpleDate) {
			final SimpleDate date = (SimpleDate) obj;
			return (this.year == date.year) && (this.month == date.month)
					&& (this.day == date.day);
		} else if (obj instanceof Date) {
			return this.equals(new SimpleDate((Date) obj));
		} else {
			return super.equals(obj);
		}
	}

	public boolean after(SimpleDate when) {
		if (when.year < this.year) {
			return true;
		} else if (when.year > this.year) {
			return false;
		} else {
			if (when.month < this.month) {
				return true;
			} else if (when.month > this.month) {
				return false;
			} else {
				return when.day < this.day;
			}
		}
	}

	public boolean before(SimpleDate when) {
		if (when.year > this.year) {
			return true;
		} else if (when.year < this.year) {
			return false;
		} else {
			if (when.month > this.month) {
				return true;
			} else if (when.month < this.month) {
				return false;
			} else {
				return when.day > this.day;
			}
		}
	}

	/**
	 * Pʂł̍vZ܂B <br>
	 * 2004/3/11 - 2004/3/11 = 0 <br>
	 * 2004/3/11 - 2004/3/1 = 10 <br>
	 * 2004/3/1 - 2004/3/11 = -10 <br>
	 * 
	 * @param when
	 * @return when - this
	 */
	public int getDayGap(SimpleDate when) {
		int result = 0;
		if (when.getYear() > this.getYear()) {
			//N܂ł̋
			result = getDayGap(new SimpleDate(this.getYear(), 12, 31));
			//N玟̌U܂ł̋
			result++;
			//eŇU玟̔ŇU܂ł̋
			for (int y = this.getYear() + 1; y < when.getYear(); y++)
				result += (DateUtils.isLeapYear(y) ? 366 : 365);
			//when̔ŇUwhen܂ł̋
			result += new SimpleDate(when.getYear(), 1, 1).getDayGap(when);
			return result;
		} else if (when.getYear() < this.getYear()) {
			//U܂ł̋
			result = getDayGap(new SimpleDate(this.getYear(), 1, 1));
			//eŇU炻̑O̔ŇU܂ł̋
			for (int y = this.getYear() - 1; y > when.getYear(); y--)
				result -= (DateUtils.isLeapYear(y) ? 366 : 365);
			//UA܂ł̋
			result--;
			//when̔N̑Awhen܂ł̋
			result += new SimpleDate(when.getYear(), 12, 31).getDayGap(when);
			return result;
		} else {
			if (when.getMonth() > this.getMonth()) {
				//܂ł̋
				result += (DateUtils.getLastDayOfMonth(this.getYear(), this
						.getMonth()) - this.getDay());
				//玟̌1܂ł̋
				result++;
				//e1玟̌1܂ŋ
				for (int m = this.getMonth() + 1; m < when.getMonth(); m++)
					result += DateUtils.getLastDayOfMonth(this.getYear(), m);
				//wheň1when̓܂ŋ
				result += (when.getDay() - 1);
				return result;
			} else if (when.month < this.month) {
				//挎܂ł̋
				result -= this.getDay();
				//e̖Ǒ̖܂ł̋
				for (int m = this.getMonth() - 1; m > when.getMonth(); m--)
					result -= DateUtils.getLastDayOfMonth(this.getYear(), m);
				//wheň̖when̓܂ł̋
				result -= (DateUtils.getLastDayOfMonth(when.getYear(), when
						.getMonth()) - when.getDay());
				return result;
			} else {
				return when.day - this.day;
			}
		}
	}

	/**
	 * Pʂł̍vZ܂B <br>
	 * 2004/3/11 - 2004/3/11 = 0 <br>
	 * 2004/3/11 - 2004/3/1 = 0 <br>
	 * 2004/3/1 - 2004/3/31 = 0 <br>
	 * 2004/3/11 - 2004/2/1 = 1 <br>
	 * 2004/2/1 - 2004/3/11 = -1<br>
	 * 2004/2/29 - 2004/3/1 = -1<br>
	 * 2004/4/1 - 2004/3/31 = 1 <br>
	 * 2004/6/1 - 2004/3/31 = 3 <br>
	 * 
	 * @param when
	 * @return when - this
	 */
	public int getMonthGap(SimpleDate when) {
		int result = 0;
		if (when.getYear() > this.getYear()) {
			//12܂ł̋
			result = 12 - this.getMonth();
			//eN12玟̔N12܂ł̋
			for (int y = this.getYear() + 1; y < when.getYear(); y++)
				result += 12;
			//when̔N̑O12when܂ł̋
			result += when.getMonth();
			return result;
		} else if (when.getYear() < this.getYear()) {
			//this̔N̑O12܂ł̋
			result -= this.getMonth();
			//eN12炻̑O̔N12܂ł̋
			for (int y = this.getYear() + 1; y < when.getYear(); y++)
				result -= 12;
			//when̔N12when܂ł̋
			result -= (12 - when.getMonth());
			return result;
		} else {
			return when.getMonth() - this.getMonth();
		}
	}

	/**
	 * NPʂł̍vZ܂B <br>
	 * 2004/3/11 - 2004/3/11 = 0 <br>
	 * 2004/1/1 - 2004/12/31 = 0 <br>
	 * 2005/3/11 - 2004/2/1 = 1 <br>
	 * 2003/2/1 - 2004/3/11 = -1<br>
	 * 2004/12/31 - 2003/1/1 = 1 <br>
	 * 2004/1/1 - 2003/12/31 = 1 <br>
	 * 2005/1/1 - 2003/12/1 = 2 <br>
	 * 2003/12/31 - 2005/1/1 = -2<br>
	 * 
	 * @param when
	 * @return when - this
	 */
	public int getYearGap(SimpleDate when) {
		return when.getYear() - this.getYear();
	}

	/**
	 * jԂ܂B
	 * 
	 * @return CalendarNXŒ`ĂSUNDAYSATURDAY܂ł̂ǂꂩB
	 */
	public int getDayOfWeek() {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(this.toDate());
		return calendar.get(Calendar.DAY_OF_WEEK);
	}

	/**
	 * @return @see java.lang.Object#toString()
	 */
	public String toString() {
		return year + "/" + month + "/" + day;
	}

	/**
	 * @return
	 */
	public int getDay() {
		return day;
	}

	/**
	 * @return
	 */
	public int getMonth() {
		return month;
	}

	/**
	 * @return
	 */
	public int getYear() {
		return year;
	}

	public SimpleDate prev(int length, int unit) {
		return next(-length, unit);
	}

	public SimpleDate next(int length, int unit) {
		final Calendar calendar = Calendar.getInstance();
		calendar.setTime(this.toDate());
		calendar.add(unit, length);
		return new SimpleDate(calendar.getTime());
	}

}