/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * @author Akima
 */
public class ResultSetWrapper extends Wrapper implements ResultSet {

	/**
	 * Constructor for ResultSetWrapper.
	 */
	public ResultSetWrapper(ResultSet impl) {
		super(impl);
		this.impl = impl;
	}

	protected final ResultSet impl;

	/**
	 * @param row
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean absolute(int row) throws SQLException {
		return impl.absolute(row);
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void afterLast() throws SQLException {
		impl.afterLast();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void beforeFirst() throws SQLException {
		impl.beforeFirst();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void cancelRowUpdates() throws SQLException {
		impl.cancelRowUpdates();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void clearWarnings() throws SQLException {
		impl.clearWarnings();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void close() throws SQLException {
		impl.close();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void deleteRow() throws SQLException {
		impl.deleteRow();
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int findColumn(String columnName) throws SQLException {
		return impl.findColumn(columnName);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean first() throws SQLException {
		return impl.first();
	}

	/**
	 * @param i
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Array getArray(int i) throws SQLException {
		return impl.getArray(i);
	}

	/**
	 * @param colName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Array getArray(String colName) throws SQLException {
		return impl.getArray(colName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public InputStream getAsciiStream(int columnIndex) throws SQLException {
		return impl.getAsciiStream(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public InputStream getAsciiStream(String columnName) throws SQLException {
		return impl.getAsciiStream(columnName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
		return impl.getBigDecimal(columnIndex);
	}

	/**
	 * @param columnIndex
	 * @param scale
	 * @return @throws
	 *         java.sql.SQLException
	 * @deprecated
	 */
	public BigDecimal getBigDecimal(int columnIndex, int scale)
			throws SQLException {
		//return impl.getBigDecimal(columnIndex, scale);
		return null;
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public BigDecimal getBigDecimal(String columnName) throws SQLException {
		return impl.getBigDecimal(columnName);
	}

	/**
	 * @param columnName
	 * @param scale
	 * @return @throws
	 *         java.sql.SQLException
	 * @deprecated
	 */
	public BigDecimal getBigDecimal(String columnName, int scale)
			throws SQLException {
		return null;
		//return impl.getBigDecimal(columnName, scale);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public InputStream getBinaryStream(int columnIndex) throws SQLException {
		return impl.getBinaryStream(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public InputStream getBinaryStream(String columnName) throws SQLException {
		return impl.getBinaryStream(columnName);
	}

	/**
	 * @param i
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Blob getBlob(int i) throws SQLException {
		return impl.getBlob(i);
	}

	/**
	 * @param colName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Blob getBlob(String colName) throws SQLException {
		return impl.getBlob(colName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean getBoolean(int columnIndex) throws SQLException {
		return impl.getBoolean(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean getBoolean(String columnName) throws SQLException {
		return impl.getBoolean(columnName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public byte getByte(int columnIndex) throws SQLException {
		return impl.getByte(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public byte getByte(String columnName) throws SQLException {
		return impl.getByte(columnName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public byte[] getBytes(int columnIndex) throws SQLException {
		return impl.getBytes(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public byte[] getBytes(String columnName) throws SQLException {
		return impl.getBytes(columnName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Reader getCharacterStream(int columnIndex) throws SQLException {
		return impl.getCharacterStream(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Reader getCharacterStream(String columnName) throws SQLException {
		return impl.getCharacterStream(columnName);
	}

	/**
	 * @param i
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Clob getClob(int i) throws SQLException {
		return impl.getClob(i);
	}

	/**
	 * @param colName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Clob getClob(String colName) throws SQLException {
		return impl.getClob(colName);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getConcurrency() throws SQLException {
		return impl.getConcurrency();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getCursorName() throws SQLException {
		return impl.getCursorName();
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Date getDate(int columnIndex) throws SQLException {
		return impl.getDate(columnIndex);
	}

	/**
	 * @param columnIndex
	 * @param cal
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Date getDate(int columnIndex, Calendar cal) throws SQLException {
		return impl.getDate(columnIndex, cal);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Date getDate(String columnName) throws SQLException {
		return impl.getDate(columnName);
	}

	/**
	 * @param columnName
	 * @param cal
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Date getDate(String columnName, Calendar cal) throws SQLException {
		return impl.getDate(columnName, cal);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public double getDouble(int columnIndex) throws SQLException {
		return impl.getDouble(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public double getDouble(String columnName) throws SQLException {
		return impl.getDouble(columnName);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getFetchDirection() throws SQLException {
		return impl.getFetchDirection();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getFetchSize() throws SQLException {
		return impl.getFetchSize();
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public float getFloat(int columnIndex) throws SQLException {
		return impl.getFloat(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public float getFloat(String columnName) throws SQLException {
		return impl.getFloat(columnName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getInt(int columnIndex) throws SQLException {
		return impl.getInt(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getInt(String columnName) throws SQLException {
		return impl.getInt(columnName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public long getLong(int columnIndex) throws SQLException {
		return impl.getLong(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public long getLong(String columnName) throws SQLException {
		return impl.getLong(columnName);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public ResultSetMetaData getMetaData() throws SQLException {
		return impl.getMetaData();
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Object getObject(int columnIndex) throws SQLException {
		return impl.getObject(columnIndex);
	}

	/**
	 * @param i
	 * @param map
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Object getObject(int i, Map map) throws SQLException {
		return impl.getObject(i, map);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Object getObject(String columnName) throws SQLException {
		return impl.getObject(columnName);
	}

	/**
	 * @param colName
	 * @param map
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Object getObject(String colName, Map map) throws SQLException {
		return impl.getObject(colName, map);
	}

	/**
	 * @param i
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Ref getRef(int i) throws SQLException {
		return impl.getRef(i);
	}

	/**
	 * @param colName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Ref getRef(String colName) throws SQLException {
		return impl.getRef(colName);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getRow() throws SQLException {
		return impl.getRow();
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public short getShort(int columnIndex) throws SQLException {
		return impl.getShort(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public short getShort(String columnName) throws SQLException {
		return impl.getShort(columnName);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Statement getStatement() throws SQLException {
		return impl.getStatement();
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getString(int columnIndex) throws SQLException {
		return impl.getString(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getString(String columnName) throws SQLException {
		return impl.getString(columnName);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Time getTime(int columnIndex) throws SQLException {
		return impl.getTime(columnIndex);
	}

	/**
	 * @param columnIndex
	 * @param cal
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Time getTime(int columnIndex, Calendar cal) throws SQLException {
		return impl.getTime(columnIndex, cal);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Time getTime(String columnName) throws SQLException {
		return impl.getTime(columnName);
	}

	/**
	 * @param columnName
	 * @param cal
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Time getTime(String columnName, Calendar cal) throws SQLException {
		return impl.getTime(columnName, cal);
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Timestamp getTimestamp(int columnIndex) throws SQLException {
		return impl.getTimestamp(columnIndex);
	}

	/**
	 * @param columnIndex
	 * @param cal
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Timestamp getTimestamp(int columnIndex, Calendar cal)
			throws SQLException {
		return impl.getTimestamp(columnIndex, cal);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Timestamp getTimestamp(String columnName) throws SQLException {
		return impl.getTimestamp(columnName);
	}

	/**
	 * @param columnName
	 * @param cal
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Timestamp getTimestamp(String columnName, Calendar cal)
			throws SQLException {
		return impl.getTimestamp(columnName, cal);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getType() throws SQLException {
		return impl.getType();
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 * @deprecated
	 */
	public InputStream getUnicodeStream(int columnIndex) throws SQLException {
		//return impl.getUnicodeStream(columnIndex);
		return null;
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 * @deprecated
	 */
	public InputStream getUnicodeStream(String columnName) throws SQLException {
		//return impl.getUnicodeStream(columnName);
		return null;
	}

	/**
	 * @param columnIndex
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public URL getURL(int columnIndex) throws SQLException {
		return impl.getURL(columnIndex);
	}

	/**
	 * @param columnName
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public URL getURL(String columnName) throws SQLException {
		return impl.getURL(columnName);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public SQLWarning getWarnings() throws SQLException {
		return impl.getWarnings();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void insertRow() throws SQLException {
		impl.insertRow();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isAfterLast() throws SQLException {
		return impl.isAfterLast();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isBeforeFirst() throws SQLException {
		return impl.isBeforeFirst();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isFirst() throws SQLException {
		return impl.isFirst();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isLast() throws SQLException {
		return impl.isLast();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean last() throws SQLException {
		return impl.last();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void moveToCurrentRow() throws SQLException {
		impl.moveToCurrentRow();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void moveToInsertRow() throws SQLException {
		impl.moveToInsertRow();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean next() throws SQLException {
		return impl.next();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean previous() throws SQLException {
		return impl.previous();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void refreshRow() throws SQLException {
		impl.refreshRow();
	}

	/**
	 * @param rows
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean relative(int rows) throws SQLException {
		return impl.relative(rows);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean rowDeleted() throws SQLException {
		return impl.rowDeleted();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean rowInserted() throws SQLException {
		return impl.rowInserted();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean rowUpdated() throws SQLException {
		return impl.rowUpdated();
	}

	/**
	 * @param direction
	 * @throws java.sql.SQLException
	 */
	public void setFetchDirection(int direction) throws SQLException {
		impl.setFetchDirection(direction);
	}

	/**
	 * @param rows
	 * @throws java.sql.SQLException
	 */
	public void setFetchSize(int rows) throws SQLException {
		impl.setFetchSize(rows);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateArray(int columnIndex, Array x) throws SQLException {
		impl.updateArray(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateArray(String columnName, Array x) throws SQLException {
		impl.updateArray(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void updateAsciiStream(int columnIndex, InputStream x, int length)
			throws SQLException {
		impl.updateAsciiStream(columnIndex, x, length);
	}

	/**
	 * @param columnName
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void updateAsciiStream(String columnName, InputStream x, int length)
			throws SQLException {
		impl.updateAsciiStream(columnName, x, length);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBigDecimal(int columnIndex, BigDecimal x)
			throws SQLException {
		impl.updateBigDecimal(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBigDecimal(String columnName, BigDecimal x)
			throws SQLException {
		impl.updateBigDecimal(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void updateBinaryStream(int columnIndex, InputStream x, int length)
			throws SQLException {
		impl.updateBinaryStream(columnIndex, x, length);
	}

	/**
	 * @param columnName
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void updateBinaryStream(String columnName, InputStream x, int length)
			throws SQLException {
		impl.updateBinaryStream(columnName, x, length);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBlob(int columnIndex, Blob x) throws SQLException {
		impl.updateBlob(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBlob(String columnName, Blob x) throws SQLException {
		impl.updateBlob(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBoolean(int columnIndex, boolean x) throws SQLException {
		impl.updateBoolean(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBoolean(String columnName, boolean x) throws SQLException {
		impl.updateBoolean(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateByte(int columnIndex, byte x) throws SQLException {
		impl.updateByte(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateByte(String columnName, byte x) throws SQLException {
		impl.updateByte(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBytes(int columnIndex, byte[] x) throws SQLException {
		impl.updateBytes(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateBytes(String columnName, byte[] x) throws SQLException {
		impl.updateBytes(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void updateCharacterStream(int columnIndex, Reader x, int length)
			throws SQLException {
		impl.updateCharacterStream(columnIndex, x, length);
	}

	/**
	 * @param columnName
	 * @param reader
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void updateCharacterStream(String columnName, Reader reader,
			int length) throws SQLException {
		impl.updateCharacterStream(columnName, reader, length);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateClob(int columnIndex, Clob x) throws SQLException {
		impl.updateClob(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateClob(String columnName, Clob x) throws SQLException {
		impl.updateClob(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateDate(int columnIndex, Date x) throws SQLException {
		impl.updateDate(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateDate(String columnName, Date x) throws SQLException {
		impl.updateDate(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateDouble(int columnIndex, double x) throws SQLException {
		impl.updateDouble(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateDouble(String columnName, double x) throws SQLException {
		impl.updateDouble(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateFloat(int columnIndex, float x) throws SQLException {
		impl.updateFloat(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateFloat(String columnName, float x) throws SQLException {
		impl.updateFloat(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateInt(int columnIndex, int x) throws SQLException {
		impl.updateInt(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateInt(String columnName, int x) throws SQLException {
		impl.updateInt(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateLong(int columnIndex, long x) throws SQLException {
		impl.updateLong(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateLong(String columnName, long x) throws SQLException {
		impl.updateLong(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @throws java.sql.SQLException
	 */
	public void updateNull(int columnIndex) throws SQLException {
		impl.updateNull(columnIndex);
	}

	/**
	 * @param columnName
	 * @throws java.sql.SQLException
	 */
	public void updateNull(String columnName) throws SQLException {
		impl.updateNull(columnName);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateObject(int columnIndex, Object x) throws SQLException {
		impl.updateObject(columnIndex, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void updateObject(int columnIndex, Object x, int scale)
			throws SQLException {
		impl.updateObject(columnIndex, x, scale);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateObject(String columnName, Object x) throws SQLException {
		impl.updateObject(columnName, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void updateObject(String columnName, Object x, int scale)
			throws SQLException {
		impl.updateObject(columnName, x, scale);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateRef(int columnIndex, Ref x) throws SQLException {
		impl.updateRef(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateRef(String columnName, Ref x) throws SQLException {
		impl.updateRef(columnName, x);
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void updateRow() throws SQLException {
		impl.updateRow();
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateShort(int columnIndex, short x) throws SQLException {
		impl.updateShort(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateShort(String columnName, short x) throws SQLException {
		impl.updateShort(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateString(int columnIndex, String x) throws SQLException {
		impl.updateString(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateString(String columnName, String x) throws SQLException {
		impl.updateString(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateTime(int columnIndex, Time x) throws SQLException {
		impl.updateTime(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateTime(String columnName, Time x) throws SQLException {
		impl.updateTime(columnName, x);
	}

	/**
	 * @param columnIndex
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateTimestamp(int columnIndex, Timestamp x)
			throws SQLException {
		impl.updateTimestamp(columnIndex, x);
	}

	/**
	 * @param columnName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void updateTimestamp(String columnName, Timestamp x)
			throws SQLException {
		impl.updateTimestamp(columnName, x);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean wasNull() throws SQLException {
		return impl.wasNull();
	}

}