/**
 * brownie-lang.js
 * 
 * uses
 *  brownie-lang.js;
 *
 * @author T.Akima
 * @copyright T.Akima
 * @license LGPL
 */


/*********************************************************************
 * ValidatioñC^tF[XEEEE`łƂ񂾂ǁA
 * łȂŃNXƂĒ`
 *********************************************************************/
function AbstractValidation(){
	this.initVariables();
}

/**
 * visibility: protected
 */
AbstractValidation.prototype.initVariables = function(){
	this._msg = null;
	this._fieldName = null;
}

/**
 * visibility: public
 * hNXoverrideĂˁB
 */
AbstractValidation.prototype.execute = function( value ) {
	return false;
}

/**
 * visibility: protected
 * hNXoverrideĂˁB
 */
AbstractValidation.prototype.getMessage4Field = function( fieldName ) {
	return fieldName;
}

/**
 * visibility: protected
 * hNXoverrideĂˁB
 */
AbstractValidation.prototype.getDefaultMessage = function() {
	return "";
}

AbstractValidation.prototype.getMessage = function() {
		if (this._msg != null)
			return this._msg;
		else if (this.getFieldName() != null)
			return this.getMessage4Field( this.getFieldName() );
		else
			return this.getDefaultMessage();
}
AbstractValidation.prototype.setMessage = function( value ) {
	this._msg = value;
}

AbstractValidation.prototype.getFieldName = function() {
	return this._fieldName;
}
AbstractValidation.prototype.setFieldName = function( value ) {
	this._fieldName = value;
}


new AbstractValidation(); //pp̃_~[𐶐

/*********************************************************************
 * ̓tB[h̃CxgValidatorsA_v^
 *********************************************************************/
var _showingAlert = false;

function _showAlert( msg ) {
	if (_showingAlert)
		return false;
	_showingAlert = true;
	try {
		alert( msg );
	} catch(e) {
		//glogger.debugObj("error occured when alert", e);
	} finally {
		_showingAlert = false;
	}
	return true;
}

function FormValidatorAdapter(form) {
	var _validatorAdapters = new ArrayList();
	var _form = form;
		
	this.add = function( validatorAdapter ) {
		_validatorAdapters.add( validatorAdapter );
	}
	
	var _invokeValidators = function( e ) {
		var msg = null;
		var focused = null;
		for(var i = 0; i < _validatorAdapters.size(); i++) {
			var adapter = _validatorAdapters.get(i);
			if (! adapter.isCheckOnSubmit())
				continue;
			var v = adapter.getValidator();
			var ctrl = adapter.getField();
			if (v.execute( ctrl.value))
				continue;
			if (focused == null)
				focused = ctrl;
			if (msg == null) 
				msg = v.getMessage();
			else
				msg = msg + "\n" + v.getMessage();
		}
		if ((focused == null) && (msg == null))
			return true;
		if ( msg != null )
			_showAlert( msg );
		if ( focused != null ) {
			focused.focus();
			focused.select();
		}
		e.preventDefault();
		return false;
	}
	
	this.doOnSubmit = function( e ) {
		return _invokeValidators( e );
	}
	
	xBrowser.prepareEventTargetInterface( _form );
	_form.addEventListener("submit", this.doOnSubmit, true);
}

var formValidatorAdapterMap = new Map();

function addToFormValidatorAdapter( form, validatorAdapter ) {
	var v = formValidatorAdapterMap.get( form );
	if (v == null) {
		v = new FormValidatorAdapter( form );
		formValidatorAdapterMap.put(form, v);
	}
	v.add( validatorAdapter );
}

function ValidatorAdapter(field, validator, checkOnBlur, checkOnSubmit) {
	var _field = field;
	var _validator = validator;
	var _checkOnSubmit = checkOnSubmit;
	
	var _label = controlUtils.getLabelFor( _field );
	if (_label != null) 
		_validator.setFieldName( _label.innerHTML );
	
	var _doValidate = function( ctrl, e ) {
		if (_invokeValidator( ctrl ))
			return true;
		_showAlert( _validator.getMessage() );
		e.preventDefault();
		return false;
	}
	
	var _invokeValidator = function( ctrl ) {
		return _validator.execute( ctrl.value);
	}
	
	this.doOnBlur = function( e ) {
		if (_showingAlert)
			return true;
		return _doValidate( _field, e );
	}
	
	/**
	 * method for KeyLimitImpl
	 */
	this.isAccepable = function(e) {
		var keyCode = xBrowser.getKeyCode(e);
		switch (keyCode) {
			case KEY_CODE_TAB.code: 
				var b = _doValidate( _field, e );
				if (! b) {
					_field.focus();
					_field.select();
					e.preventDefault();
				}
				return b
		}
		return true;
	}
	
	
	if (checkOnBlur) {
		new KeyLimitImpl(_field, this, false);
		xBrowser.prepareEventTargetInterface( _field );
		_field.addEventListener("blur", this.doOnBlur, true);
	}
	
	addToFormValidatorAdapter( _field.form, this );

	this.getField = function() {
		return _field;
	}
	
	this.getValidator = function() {
		return _validator;
	}
	
	this.isCheckOnSubmit = function() {
		return _checkOnSubmit;
	}
	
}


/*********************************************************************
 * `FbN ۃNX
 *********************************************************************/
function AbstractCompositeValidation(){
	this.initVariables();
}

inherit(AbstractCompositeValidation, AbstractValidation);

AbstractCompositeValidation.prototype.super_initVariables = AbstractCompositeValidation.prototype.initVariables;

AbstractCompositeValidation.prototype.initVariables = function() {
	this.super_initVariables();
	this._validations = new ArrayList();
}

/**
 * override
 */
AbstractCompositeValidation.prototype.setFieldName = function( value ) {
	this._fieldName = value;
	var size = this.size();
	for(var i =0; i < size; i++) {
		var validation = this.get( i );
		validation.setFieldName( value );
	}
}

AbstractCompositeValidation.prototype.clear = function(){
	this._validations.clear();
}
AbstractCompositeValidation.prototype.add = function( validation ){
	this._validations.add(validation);
}
AbstractCompositeValidation.prototype.remove = function( validation ){
	this._validations.remove(validation);
}
AbstractCompositeValidation.prototype.get = function( index ){
	return this._validations.get(index);
}
AbstractCompositeValidation.prototype.isEmpty = function(){
	return this._validations.isEmpty();
}
AbstractCompositeValidation.prototype.size = function(){
	return this._validations.size();
}




/*********************************************************************
 * AND`FbN 
 *********************************************************************/
function CompositeValidationAND(){
	this.initVariables();
}

inherit(CompositeValidationAND, AbstractCompositeValidation);

/**
 * override
 */
CompositeValidationAND.prototype.execute = function( value ) {
	var size = this.size();
	var msg = null;
	var result = true;
	for(var i =0; i < size; i++) {
		var validation = this.get( i );
		if (validation.execute( value )){
			//glogger.debug( "validation success: " + validation );
		} else {
			//glogger.debug( "validation failed: " + validation );
			result = false;
			if (msg == null)
				msg = validation.getMessage();
			else
				msg = msg + "\n" + validation.getMessage();
		}
	}
	this.setMessage( msg );
	return result;
}

/*********************************************************************
 * OR`FbN 
 *********************************************************************/
function CompositeValidationOR(){
	this.initVariables();
}

inherit(CompositeValidationOR, AbstractCompositeValidation);

/**
 * override
 */
CompositeValidationOR.prototype.execute = function( value ) {
	var size = this.size();
	var msg = null;
	for(var i =0; i < size; i++) {
		var validation = this.get( i );
		if (validation.execute( value )){
			return true;
		} else {
			if (msg == null)
				msg = validation.getMessage();
			else
				msg = msg + "\n܂" + validation.getMessage();
		}
	}
	this._msg = msg;
	return false;
}

/*********************************************************************
 * K{̓`FbN
 *********************************************************************/
function RequiredValidation(){
	this.initVariables();
}

inherit(RequiredValidation, AbstractValidation);

/**
 * visibility: public
 * override
 */
RequiredValidation.prototype.execute = function( value ) {
	return ! stringUtils.isEmpty( value );
}

/**
 * override
 */
RequiredValidation.prototype.getMessage4Field = function( fieldName ) {
	return fieldName + "͂Ă";
}

/**
 * override
 */
RequiredValidation.prototype.getDefaultMessage = function() {
	return "K͂Ă";
}

/*********************************************************************
 * t\ȕ̃`FbN
 *********************************************************************/
function AcceptableValidation( acceptableCaption, acceptable, refused ){
	this.initVariables();
	this.setAcceptableCaption(acceptableCaption);
	this.setAcceptable(acceptable);
	this.setRefused( refused );
}

inherit(AcceptableValidation, AbstractValidation);

/**
 * visibility: public
 * override
 */
AcceptableValidation.prototype.execute = function( value ) {
	if (this.getAcceptable() == null)
		return true;
	if (value == null)
		return true;
	if (value.length < 1)
		return true;
	if (this.isRefused())
		return ! this.checkStringAcceptable( value, this.getAcceptable() );
	else
		return this.checkStringAcceptable( value, this.getAcceptable() );
}

/**
 * t\ۂ𔻒fB
 * valueacceptableɊ܂܂ȂꍇfalseA
 * value\镶񂪑SacceptableɊ܂܂ꍇtrueB
 * valuenullȂtrueAacceptablenullȂfalseB
 */
AcceptableValidation.prototype.checkStringAcceptable = function( value, acceptable ) {
	for (var i = 0; i < value.length ; i++) {
		if (acceptable.indexOf(value.charAt(i)) == -1) 
			return false;
	}
	return true;
}

/**
 * override
 */
AcceptableValidation.prototype.getMessage4Field = function( fieldName ) {
	return fieldName + "" + this.getDefaultMessage();
}

/**
 * override
 */
AcceptableValidation.prototype.getDefaultMessage = function() {
	if (this.isRefused())
		return this.getAcceptableCaption() + "͂ȂłB";
	else
		return "͉\ȕ" + this.getAcceptableCaption() + "łB";
}

AcceptableValidation.prototype.getAcceptableCaption = function(){
	return this._acceptableCaption;
}
AcceptableValidation.prototype.setAcceptableCaption = function( value ){
	this._acceptableCaption = value;
}
AcceptableValidation.prototype.getAcceptable = function(){
	return this._acceptable;
}
AcceptableValidation.prototype.setAcceptable = function( value ){
	this._acceptable = value;
}
AcceptableValidation.prototype.isRefused = function(){
	return this._refured;
}
AcceptableValidation.prototype.setRefused  = function( value ){
	this._refured = value;
}

/*********************************************************************
 * ̒`FbN
 *********************************************************************/
function LengthValidation( length ){
	this.initVariables();
	this.setLength( length );
}

inherit(LengthValidation, AbstractValidation);

/**
 * visibility: public
 * override
 */
LengthValidation.prototype.execute = function( value ) {
	return this.getLength() >= value.length;
}

/**
 * override
 */
LengthValidation.prototype.getMessage4Field = function( fieldName ) {
	return fieldName + "" + this.getDefaultMessage();
}

/**
 * override
 */
LengthValidation.prototype.getDefaultMessage = function() {
	return "͉\Ȓ" + this.getLength() + "܂łłB";
}

LengthValidation.prototype.getLength = function(){
	return this._length;
}
LengthValidation.prototype.setLength = function( value ){
	this._length = value;
}
/*********************************************************************
 * K\`FbN
 *********************************************************************/
function RegExpValidation( expression ){
	this.initVariables();
	this.setExpression( expression );
}

inherit(RegExpValidation, AbstractValidation);

/**
 * visibility: public
 * override
 */
RegExpValidation.prototype.execute = function( value ) {
	if (this.getExpression() == null)
		return true;
	/*
	 * i 啶EʂȂ 
	 * g 2ԖځA3Ԗ... Ƀ}b`镔 
	 * m sɑ΂Č (e55/N6) 
	 */
	var re = new RegExp(getExpression(), "i");
	return this.value.matches(re);
}

/**
 * override
 */
RegExpValidation.prototype.getMessage4Field = function( fieldName ) {
	return fieldName + "" + this.getDefaultMessage();
}

/**
 * override
 */
RegExpValidation.prototype.getDefaultMessage = function() {
	return "`܂B";
}

RegExpValidation.prototype.getExpression = function(){
	return this._regExp;
}
RegExpValidation.prototype.setExpression = function( value ){
	this._regExp = value;
}
