/*
 * Created on 2004/06/04
 */
package org.asyrinx.brownie.net.socket;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author akima
 */
public class SocketService implements Runnable {
	/**
	 *  
	 */
	public SocketService(SocketServerListener listener) {
		super();
		this.listener = listener;
	}

	public static final int DEFAULT_PORT = 5555;

	private final SocketServerListener listener;

	private int port = DEFAULT_PORT;

	private final Log log = LogFactory.getLog(this.getClass());

	private boolean running = false;

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		while (running) {
			final SocketServer server = new SocketServer(listener, this.port);
			try {
				server.receive();
			} catch (IOException e) {
				log.error("", e);
				running = false;
			}
		}
	}

	public void start() {
		//do nothing
	}

	public void stop() {
		running = false;

	}
}