/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/04/09 14:33:40
 */
package org.asyrinx.brownie.seasar.servlet;

import java.io.File;

import javax.servlet.ServletContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.seasar.container.factory.BrownieS2ContainerFactory;
import org.asyrinx.brownie.servlet.FileNameResolver;
import org.seasar.framework.container.S2Container;

/**
 * @author akima
 */
public class S2ContainerLoader {

    public static final String SERVLET_CONTEXT_PARAM_INITFILE = "s2config";

    public static final String SERVLET_CONTEXT_PARAM_BASE_PATHES = "basePathes";

    public static final String SERVLET_CONTEXT_ATTRIBUTE_CONTAINER = S2ContainerLoader.class
            .getName()
            + ".container";

    final Log log = LogFactory.getLog(this.getClass());

    public S2ContainerLoader(ServletContext context) {
        this.context = context;
        this.resolver = new FileNameResolver(this.context);
    }

    private final ServletContext context;

    private final FileNameResolver resolver;

    private S2Container createContainerByBrownie() {
        final String webContextRealPath = resolver.getContextRootPath();
        final String s2config = getReplacedContextParameter(SERVLET_CONTEXT_PARAM_INITFILE);
        final String basePathes = getReplacedContextParameter(SERVLET_CONTEXT_PARAM_BASE_PATHES);
        final String pathes = webContextRealPath
                + (StringUtils.isEmpty(basePathes) ? "" : (File.pathSeparator + basePathes));
        log.info(SERVLET_CONTEXT_PARAM_INITFILE + ": " + s2config);
        log.info(SERVLET_CONTEXT_PARAM_BASE_PATHES + ": " + basePathes);
        log.info("pathes: " + pathes);
        try {
            final S2Container container = BrownieS2ContainerFactory.create(s2config, pathes);
            container.setServletContext(this.context);
            return container;
        } catch (RuntimeException e) {
            log.error("failed to create S2Container", e);
            throw e;
        }
    }

    private String getReplacedContextParameter(String key) {
        return StringUtils.replaceWithProperties(context.getInitParameter(key), System
                .getProperties());
    }

    public S2Container createContainer() {
        return createContainerByBrownie();
    }

    private S2Container container = null;

    public void initializeContainer() {
        container = createContainer();
        this.context.setAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER, container);
    }

    public void finalizeContainer() {
        if (container != null)
            container.destroy();
    }

    public static S2Container getContainer(ServletContext context) {
        return (S2Container) context.getAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER);
    }
}