/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 0:23:52
 */
package org.asyrinx.brownie.swing.table.calc;

import java.util.HashMap;
import java.util.Map;

import javax.swing.table.TableModel;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.collection.calc.Calculation;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.swing.table.key.AbstractColumn;
import org.asyrinx.brownie.swing.table.key.Column;
import org.asyrinx.brownie.swing.table.key.RowKey;
import org.asyrinx.brownie.swing.table.key.RowKeyContainer;

/**
 * @author akima
 */
public class CalcColumnImpl extends AbstractColumn implements Column {

    /**
     * @param originalColumnIndex
     * @param tableModel
     * @param keyContainer
     */
    public CalcColumnImpl(int originalColumnIndex, TableModel tableModel, RowKeyContainer keyContainer,
            Calculation calculation, String name) {
        super(originalColumnIndex, tableModel, keyContainer);
        this.calculation = calculation;
        this.name = name;
    }

    private final String name;

    private final Calculation calculation;

    private static final Map calcNames = initCalcNames();

    /**
     * @return
     */
    private static Map initCalcNames() {
        final Map result = new HashMap();
        result.put(Calculation.SUMMARY, "sum");
        result.put(Calculation.COUNT, "count");
        result.put(Calculation.AVERAGE, "average");
        result.put(Calculation.MIN, "min");
        result.put(Calculation.MAX, "max");
        return result;
    }

    /**
     * @return Returns the calculation.
     */
    public Calculation getCalculation() {
        return calculation;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.swing.table.Column#getColumnClass()
     */
    public Class getColumnClass() {
        return Number.class;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.swing.table.Column#getColumnName()
     */
    public String getColumnName() {
        if (!StringUtils.isEmpty(this.name))
            return this.name;
        final Object calcName = calcNames.get(this.calculation);
        String result = tableModel.getColumnName(getOriginalColumnIndex());
        return (calcName == null) ? result : calcName + "(" + result + ")";
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.swing.table.Column#getValueAt(int)
     */
    public Object getValueAt(int rowIndex) {
        final RowKey key = keyContainer.getKey(rowIndex);
        final int[] targetKeyRowIndexes = key.getTargetKeyIndexes();
        final Number[] values = new Number[targetKeyRowIndexes.length];
        for (int i = 0; i < targetKeyRowIndexes.length; i++) {
            int row = targetKeyRowIndexes[i];
            values[i] = NumberUtils.toNumber(this.tableModel.getValueAt(row, getOriginalColumnIndex()));
        }
        return getCalculation().calculate(values);
    }

}