/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/05 4:05:26
 */
package org.asyrinx.brownie.swing.table.calc;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.TableModel;

import org.asyrinx.brownie.core.collection.calc.Calculation;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.swing.table.key.Column;
import org.asyrinx.brownie.swing.table.key.KeyColumn;
import org.asyrinx.brownie.swing.table.key.KeyColumnTableModel;
import org.asyrinx.brownie.swing.table.key.RowKey;
import org.asyrinx.brownie.swing.table.key.RowKeyContainer;

/**
 * @author akima
 */
public class CalcTableModelImpl extends KeyColumnTableModel implements CalcTableModel, RowKeyContainer {

    private final List calcColumns = new ArrayList();

    private final List columns = new ArrayList();

    /**
     * @param model
     */
    public CalcTableModelImpl(TableModel tableModel) {
        super(tableModel);
        initEventListener();
    }

    /**
     * @param tableModel
     * @param keyColumns
     */
    public CalcTableModelImpl(TableModel tableModel, int[] keyColumns) {
        super(tableModel, keyColumns);
        initKeyColumns(keyColumns);
        refreshKeys();
        initEventListener();
    }

    public void refreshKeys() {
        clearKeyList();
        for (int r = 0; r < tableModel.getRowCount(); r++) {
            final Object[] values = new Object[getKeyColumnCount()];
            for (int i = 0; i < getKeyColumnCount(); i++) {
                final Column column = getKeyColumn(i);
                final Object value = tableModel.getValueAt(r, column.getOriginalColumnIndex());
                values[i] = (NumberUtils.isNumber(value)) ? NumberUtils.toNumber(value) : value;
            }
            final RowKey exists = findKey(values);
            final RowKey current = new RowKey(values);
            if (exists == null) {
                addRowKey(current);
                current.addTargetRowIndex(r);
            } else {
                exists.addTargetRowIndex(r);
            }
        }
    }

    public int getCalcColumnCount() {
        return calcColumns.size();
    }

    protected void addKeyColumn(KeyColumn keyColumn) {
        columns.add(keyColumn);
        super.addKeyColumn(keyColumn);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.swing.table.CalcTableModel#addColumn(int,
     *        org.asyrinx.brownie.core.collection.calc.Calculation)
     */
    public void addCalcColumn(int originalColumnIndex, Calculation calculation) {
        addCalcColumn(originalColumnIndex, calculation, null);
    }

    public void addCalcColumn(int originalColumnIndex, Calculation calculation, String name) {
        addColumn(new CalcColumnImpl(originalColumnIndex, this.tableModel, this, calculation, name));
    }

    protected void addColumn(CalcColumnImpl calcColumn) {
        calcColumns.add(calcColumn);
        columns.add(calcColumn);
        fireTableStructureChanged();
    }

    public Column getColumn(int columnIndex) {
        return (Column) columns.get(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#getColumnClass(int)
     */
    public Class getColumnClass(int columnIndex) {
        final Column columnModel = getColumn(columnIndex);
        return (columnModel == null) ? null : columnModel.getColumnClass();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    public int getColumnCount() {
        return getKeyColumnCount() + getCalcColumnCount();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#getColumnName(int)
     */
    public String getColumnName(int columnIndex) {
        final Column columnModel = getColumn(columnIndex);
        return (columnModel == null) ? null : columnModel.getColumnName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */
    public Object getValueAt(int rowIndex, int columnIndex) {
        final Column columnModel = getColumn(columnIndex);
        return (columnModel == null) ? null : columnModel.getValueAt(rowIndex);
    }

}

