/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 3:20:16
 */
package org.asyrinx.brownie.swing.table.util;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

/**
 * @author akima
 */
public abstract class UpdatableTableModel extends AbstractTableModel {

    /**
     *  
     */
    public UpdatableTableModel() {
        super();
    }

    private boolean updating = false;

    public final void beginUpdate() {
        updating = true;
    }

    public final void endUpdate() {
        updating = false;
    }

    public final boolean isUpdating() {
        return updating;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#fireTableCellUpdated(int, int)
     */
    public void fireTableCellUpdated(int row, int column) {
        if (isUpdating())
            return;
        super.fireTableCellUpdated(row, column);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#fireTableChanged(javax.swing.event.TableModelEvent)
     */
    public void fireTableChanged(TableModelEvent e) {
        if (isUpdating())
            return;
        super.fireTableChanged(e);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#fireTableDataChanged()
     */
    public void fireTableDataChanged() {
        if (isUpdating())
            return;
        super.fireTableDataChanged();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#fireTableRowsDeleted(int, int)
     */
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        if (isUpdating())
            return;
        super.fireTableRowsDeleted(firstRow, lastRow);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#fireTableRowsInserted(int, int)
     */
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        if (isUpdating())
            return;
        super.fireTableRowsInserted(firstRow, lastRow);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#fireTableRowsUpdated(int, int)
     */
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        if (isUpdating())
            return;
        super.fireTableRowsUpdated(firstRow, lastRow);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#fireTableStructureChanged()
     */
    public void fireTableStructureChanged() {
        if (isUpdating())
            return;
        super.fireTableStructureChanged();
    }

}