/*
 * brownie-tapestry-sample and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/25 16:09:20
 */
package org.asyrinx.brownie.tapestry.components.form;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.form.AbstractTextField;

/**
 * @author takeshi
 */
public abstract class TimeField extends AbstractTextField {

    public abstract IBinding getValueBinding();

    public abstract DateFormat getFormat();

    final DateFormat[] defaultFormats = new DateFormat[] { new SimpleDateFormat("HH:mm:ss.SSS"),
            new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("HH:mm"), new SimpleDateFormat("HH"), };

    private final DateFormat defaultFormat = defaultFormats[1];

    public String readValue() {
        final Date date = (Date) getValueBinding().getObject("value", Date.class);
        if (date == null)
            return "";

        debug(date, "readValue");

        final DateFormat format = getFormat();
        if (format != null) {
            return format.format(date);
        } else {
            return defaultFormat.format(date);
        }
    }

    /**
     * @param date
     * @param methodName
     */
    private void debug(final Date date, final String methodName) {
        final Calendar dateCalendar = new GregorianCalendar();
        dateCalendar.setTime(date);
        final int h = dateCalendar.get(Calendar.HOUR_OF_DAY);
        final int m = dateCalendar.get(Calendar.MINUTE);
        final int s = dateCalendar.get(Calendar.SECOND);
        final int ms = dateCalendar.get(Calendar.MILLISECOND);
        log.debug(methodName + " h:m:s:ms=" + h + ":" + m + ":" + s + ":" + ms);
    }

    final Log log = LogFactory.getLog(this.getClass());

    public void updateValue(String value) {
        if (StringUtils.isEmpty(value))
            return;
        Date originalValue = (Date) getValueBinding().getObject("value", Date.class);
        if (originalValue == null) {
            originalValue = new Date();
        }
        final Calendar calendar = new GregorianCalendar();
        calendar.setTime(originalValue);
        final Date date = toDate(value);
        final Calendar dateCalendar = new GregorianCalendar();
        dateCalendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, dateCalendar.get(Calendar.HOUR_OF_DAY));
        calendar.set(Calendar.MINUTE, dateCalendar.get(Calendar.MINUTE));
        calendar.set(Calendar.SECOND, dateCalendar.get(Calendar.SECOND));
        calendar.set(Calendar.MILLISECOND, dateCalendar.get(Calendar.MILLISECOND));

        debug(calendar.getTime(), "readValue calendar.getTime()");

        final Date result = new Date(calendar.getTime().getTime());
        debug(result, "readValue result");
        getValueBinding().setObject(result);
    }

    private Date toDate(String value) {
        try {
            final DateFormat dateFormat = getFormat();
            if (dateFormat != null)
                return dateFormat.parse(value);
            else
                return parseByDefaultFormats(value);
        } catch (ParseException e) {
            return parseByDefaultFormats(value);
        }
    }

    private Date parseByDefaultFormats(String value) {
        for (int i = 0; i < defaultFormats.length; i++) {
            try {
                return defaultFormats[i].parse(value);
            } catch (ParseException e) {
                //ignore
            }
        }
        return null;
    }

}