/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/15 14:38:38
 */
package org.asyrinx.brownie.tapestry.components.js;

import java.util.Map;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.binding.StaticBinding;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;
import org.asyrinx.brownie.tapestry.util.BindingUtils;

/**
 * @author takeshi
 */
public abstract class JsCheckbox extends AbstractComponent implements IScriptUser {

    private final ScriptWriter scriptWriter;

    public JsCheckbox() {
        super();
        this.scriptWriter = new ScriptWriter(this, "JsCheckbox.script");
        this.scriptWriter.setUsage(ScriptUsage.ONCE_BY_OBJECT);
    }

    public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
        symbols.put("variableName", getVariableName());
        symbols.put("checkboxId", getCheckboxId());
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        this.scriptWriter.execute(cycle);
        //
        writer.beginEmpty("input");
        writer.attribute("type", "checkbox");
        renderInformalParameters(writer, cycle);
        writer.closeTag();
    }

    private String getCheckboxId() {
        final String result = BindingUtils.getInformalParameter(this, "id");
        if (result != null)
            return result;
        this.setBinding("id", new StaticBinding(getId(), this.getLocation()));
        return getId();
    }

    abstract public String getVariableName();
}