/*
 * brownie-tapestry-sample and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 2:27:04
 */
package org.asyrinx.brownie.tapestry.components.util;

import java.lang.reflect.InvocationTargetException;
import java.text.Format;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;

/**
 * @author takeshi
 */
public abstract class InsertProperty extends AbstractComponent {

    public abstract IBinding getFormatBinding();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        final Object value = getValue();
        if (value == null)
            return;
        String insert = null;
        final Format format = getFormat();
        if (format == null) {
            insert = value.toString();
        } else {
            try {
                insert = format.format(value);
            } catch (Exception ex) {
                throw new ApplicationRuntimeException(Tapestry.format("Insert.unable-to-format", value), this,
                        getFormatBinding().getLocation(), ex);
            }
        }
        final String styleClass = getStyleClass();
        if (styleClass != null) {
            writer.begin("span");
            writer.attribute("class", styleClass);
            renderInformalParameters(writer, cycle);
        }
        if (getRaw())
            writer.printRaw(insert);
        else
            writer.print(insert);

        if (styleClass != null)
            writer.end(); // <span>
    }

    /**
     * @return
     */
    private Object getValue() {
        final Object bean = getBean();
        final String property = getProperty();
        if (bean == null) {
            if (isStrict())
                throw new ApplicationRuntimeException("bean was null");
            else
                return null;
        }
        try {
            return PropertyUtils.getProperty(bean, property);
        } catch (IllegalAccessException e) {
            throw new ApplicationRuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new ApplicationRuntimeException(e);
        } catch (NoSuchMethodException e) {
            if (isStrict())
                throw new ApplicationRuntimeException(e);
            else
                return null;
        }
    }

    public abstract Object getBean();

    public abstract String getProperty();

    public abstract Format getFormat();

    public abstract String getStyleClass();

    public abstract boolean getRaw();

    public abstract boolean isStrict();
}