/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/10 21:28:00
 */
package org.asyrinx.brownie.tapestry.components.valid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;

/**
 * @author takeshi
 */
public abstract class DisplayValidationContext extends AbstractComponent implements IScriptUser {

    private final ScriptWriter scriptWriter;

    public DisplayValidationContext() {
        super();
        this.scriptWriter = new ScriptWriter(this, "DisplayValidationContext.script");
        this.scriptWriter.setUsage(ScriptUsage.ONCE_BY_OBJECT);
    }

    public abstract ValidationContext getContext();

    public abstract boolean isAlert();

    public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
        symbols.put("messages", getContextMessages());
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        if (isAlert()) {
            this.scriptWriter.execute(cycle);
        } else {
            renderMessages(writer, cycle);
        }
    }

    public List getContextMessages() {
        final ValidationContext context = getContext();
        if (context == null)
            return Collections.EMPTY_LIST;
        final List result = new ArrayList();
        for (Iterator i = context.getMessages().iterator(); i.hasNext();) {
            final Message message = (Message) i.next();
            result.add(message.getText());
        }
        return result;
    }

    private void renderMessages(IMarkupWriter writer, IRequestCycle cycle) {
        for (Iterator i = getContextMessages().iterator(); i.hasNext();) {
            final String msgText = (String) i.next();
            writer.print(msgText);
            writer.beginEmpty("br");
            writer.closeTag();
            writer.println();
        }
    }

}