/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package org.asyrinx.brownie.tapestry.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IMarkupWriter;

/**
 * @author akima
 */
public class ValueTagWriter {

	/**
	 *  
	 */
	public ValueTagWriter(IMarkupWriter writer) {
		this(writer, "span", new HashMap());
	}

	/**
	 *  
	 */
	public ValueTagWriter(IMarkupWriter writer, String tagName,
			Map extraAttributes) {
		super();
		this.writer = writer;
		this.extraAttributes = extraAttributes;
		setTagName(tagName);
	}

	private String tagName = "span";

	private final Map extraAttributes;

	protected final IMarkupWriter writer;

	protected void attributes(Map attibutes) {
		if (attibutes == null)
			return;
		final Iterator iterator = attibutes.keySet().iterator();
		while (iterator.hasNext()) {
			final String element = String.valueOf(iterator.next());
			writer.attribute(element, String.valueOf(extraAttributes
					.get(element)));
		}
	}

	public void addProperty(String id, String value) {
		if (StringUtils.isEmpty(value))
			return;
		writer.begin(getTagName());
		writer.attribute("id", id);
		attributes(getExtraAttributes());
		final IMarkupWriter innerDivWriter = writer.getNestedWriter();
		innerDivWriter.printRaw(value);
		innerDivWriter.close();
		writer.end();
		//writer.println();
	}

	public void addProperties(Map properties) {
		final Iterator iterator = properties.keySet().iterator();
		while (iterator.hasNext()) {
			final String element = String.valueOf(iterator.next());
			final Object value = properties.get(element);
			if (value instanceof Map) {
				final ValueTagWriter nestedWriter = new ValueTagWriter(
						this.writer.getNestedWriter(), getTagName(),
						getExtraAttributes());
				writer.begin(getTagName());
				writer.attribute("id", element);
				nestedWriter.addProperties((Map) value);
				nestedWriter.close();
				writer.end();
			} else {
				if (value != null)
					addProperty(element, String.valueOf(value));
			}
		}
	}

	public void close() {
		this.writer.close();
	}

	/**
	 * @return
	 */
	public Map getExtraAttributes() {
		return extraAttributes;
	}

	/**
	 * @return
	 */
	public String getTagName() {
		return tagName;
	}

	/**
	 * @param string
	 */
	public void setTagName(String string) {
		tagName = string;
	}

}