/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/11 10:57:22
 */
package org.asyrinx.brownie.tapestry.valid;

import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.ValidatorException;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidationContextFactory;
import org.asyrinx.brownie.validator.prop.AcceptableCharacters;
import org.asyrinx.brownie.validator.prop.StringField;

/**
 * @author takeshi
 */
public class StringFieldValidator extends ScriptValidator {

    /**
     *  
     */
    public StringFieldValidator(StringField stringField) {
        super("/org/asyrinx/brownie/tapestry/valid/StringFieldValidator.script");
        this.stringField = stringField;
    }

    public Object toObject(IFormComponent field, String input) throws ValidatorException {
        final ValidationContext context = createContext();
        stringField.evaluate(context, null, input);
        if (!context.getMatters().isEmpty())
            throw new ValidatorException(context.buildText(","));

        return super.toObject(field, input);
    }

    private final StringField stringField;

    public boolean isRequired() {
        return stringField.isRequired();
    }

    public int getMaxLength() {
        return stringField.getMaxLength();
    }

    public String getAccepted() {
        return stringField.getAccepted();
    }

    private String acceptedCharacters = null;

    public String getAcceptedCharacters() {
        if (this.acceptedCharacters == null) {
            final AcceptableCharacters v = stringField.getAcceptedValidator();
            this.acceptedCharacters = (v == null) ? "" : v.getCharacters().expandToString();
        }
        return this.acceptedCharacters;
    }

    private String acceptedCaption = null;

    public String getAcceptedCaption() {
        if (this.acceptedCaption == null) {
            final AcceptableCharacters v = stringField.getAcceptedValidator();
            this.acceptedCaption = (v == null) ? "" : v.getCharacters().getName();
        }
        return this.acceptedCaption;
    }

    public String getRefused() {
        return stringField.getRefused();
    }

    private String refusedCharacters = null;

    public String getRefusedString() {
        if (this.refusedCharacters == null) {
            final AcceptableCharacters v = stringField.getRefusedValidator();
            this.refusedCharacters = (v == null) ? "" : v.getCharacters().expandToString();
        }
        return this.refusedCharacters;
    }

    private String refusedCaption = null;

    public String getRefusedCaption() {
        if (this.refusedCaption == null) {
            final AcceptableCharacters v = stringField.getRefusedValidator();
            this.refusedCaption = (v == null) ? "" : v.getCharacters().getName();
        }
        return this.refusedCaption;
    }

    public String getRegExp() {
        return stringField.getRegExp();
    }

    protected ValidationContext createContext() {
        return getContextFactory().createContext();
    }

    private ValidationContextFactory contextFactory = null;

    public ValidationContextFactory getContextFactory() {
        return contextFactory;
    }

    public void setContextFactory(ValidationContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    private boolean checkOnBlur = false;

    private boolean checkOnSubmit = true;

    public boolean isCheckOnBlur() {
        return checkOnBlur;
    }

    public void setCheckOnBlur(boolean checkOnBlur) {
        this.checkOnBlur = checkOnBlur;
    }

    public boolean isCheckOnSubmit() {
        return checkOnSubmit;
    }

    public void setCheckOnSubmit(boolean checkOnSubmit) {
        this.checkOnSubmit = checkOnSubmit;
    }
}