/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/20 15:24:13
 */
package org.asyrinx.brownie.tapestry.wrapper;

import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.request.RequestContext;

/**
 * @author takeshi
 */
public class RequestCycleWrapper implements IRequestCycle {

    /**
     *  
     */
    public RequestCycleWrapper(IRequestCycle wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final IRequestCycle wrapped;

    public void activate(String name) {
        wrapped.activate(name);
    }

    public void activate(IPage page) {
        wrapped.activate(page);
    }

    public void cleanup() {
        wrapped.cleanup();
    }

    public void commitPageChanges() {
        wrapped.commitPageChanges();
    }

    public void discardPage(String name) {
        wrapped.discardPage(name);
    }

    public String encodeURL(String URL) {
        return wrapped.encodeURL(URL);
    }

    public Object getAttribute(String name) {
        return wrapped.getAttribute(name);
    }

    public IEngine getEngine() {
        return wrapped.getEngine();
    }

    public IMonitor getMonitor() {
        return wrapped.getMonitor();
    }

    public String getNextActionId() {
        return wrapped.getNextActionId();
    }

    public IPage getPage() {
        return wrapped.getPage();
    }

    public IPage getPage(String name) {
        return wrapped.getPage(name);
    }

    public RequestContext getRequestContext() {
        return wrapped.getRequestContext();
    }

    public IEngineService getService() {
        return wrapped.getService();
    }

    public Object[] getServiceParameters() {
        return wrapped.getServiceParameters();
    }

    public boolean isRewinding() {
        return wrapped.isRewinding();
    }

    public boolean isRewound(IComponent component) throws StaleLinkException {
        return wrapped.isRewound(component);
    }

    public void removeAttribute(String name) {
        wrapped.removeAttribute(name);
    }

    public void renderPage(IMarkupWriter writer) {
        wrapped.renderPage(writer);
    }

    public void rewindForm(IForm form, String targetActionId) {
        wrapped.rewindForm(form, targetActionId);
    }

    public void rewindPage(String targetActionId, IComponent targetComponent) {
        wrapped.rewindPage(targetActionId, targetComponent);
    }

    public void setAttribute(String name, Object value) {
        wrapped.setAttribute(name, value);
    }

    /**
     * @deprecated
     */
    public void setPage(String name) {
        wrapped.setPage(name);
    }

    /**
     * @deprecated
     */
    public void setPage(IPage page) {
        wrapped.setPage(page);
    }

    public void setServiceParameters(Object[] parameters) {
        wrapped.setServiceParameters(parameters);
    }
}