/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/04 21:02:55
 */
package org.asyrinx.brownie.validator;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.Predicate;

/**
 * @author takeshi
 */
public interface ValidationContext {

    void add(Message message);

    Message addMessage(String text, MessageLevel type);

    Message addMessageByKey(String key, MessageLevel type, Map parameters);

    Message addMessageByKey(String key, MessageLevel type);

    Message addFatal(String key, Map parameters);

    Message addFatal(String key);

    Message addError(String key, Map parameters);

    Message addError(String key);

    Message addWarn(String key, Map parameters);

    Message addWarn(String key);

    Message addInfo(String key, Map parameters);

    Message addInfo(String key);

    Message addDebug(String key, Map parameters);

    Message addDebug(String key);

    void addMessages(ValidationContext subContext);

    ValidationContext createSubContext();

    boolean isEmptyMessage();

    List getMessages();

    List getMessages(String propertyName);

    /**
     * w肵x̃bZ[WSĕԂ܂B
     * 
     * @param level
     * @return
     */
    //List getMessages(MessageLevel level);
    List getMessages(Predicate predicate);

    Set getProperties();

    MessageLevel getMatterLevel();

    List getMatters();

    String buildText(String delim);
}