/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 10:42:20
 */
package org.asyrinx.brownie.validator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;

/**
 * @author takeshi
 */
public class CompositeValidator implements Validator {

    /**
     *  
     */
    public CompositeValidator() {
        super();
    }

    /**
     *  
     */
    public CompositeValidator(CompositeType type) {
        super();
        setType(type);
    }

    public void evaluate(ValidationContext context, Object obj) {
        type.evaluate(this, context, obj);
    }

    public CompositeType getType() {
        return type;
    }

    public void setType(CompositeType type) {
        this.type = type;
    }

    private CompositeType type = CompositeType.AND;

    private final List validators = new ArrayList();

    public boolean add(Validator validator) {
        return validators.add(validator);
    }

    public boolean addAll(Collection c) {
        return validators.addAll(c);
    }

    public void clear() {
        validators.clear();
    }

    public boolean contains(Validator validator) {
        return validators.contains(validator);
    }

    public Validator get(int index) {
        return (Validator) validators.get(index);
    }

    public int indexOf(Validator validator) {
        return validators.indexOf(validator);
    }

    public boolean isEmpty() {
        return validators.isEmpty();
    }

    public Iterator iterator() {
        return validators.iterator();
    }

    public boolean remove(Validator validator) {
        return validators.remove(validator);
    }

    public int size() {
        return validators.size();
    }
}