/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/04 21:05:55
 */
package org.asyrinx.brownie.validator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.Predicate;
import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.ParameterizedMessageResource;
import org.asyrinx.brownie.core.resource.impl.ParameterizedMessageResourceImpl;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.MessageLevel;
import org.asyrinx.brownie.validator.ValidationContext;

/**
 * @author takeshi
 */
public class ValidationContextImpl implements ValidationContext {

    /**
     *  
     */
    public ValidationContextImpl() {
        super();
    }

    public ValidationContext createSubContext() {
        final ValidationContextImpl result = new ValidationContextImpl();
        result.setResource(this.getResource());
        result.setMatterLevel(this.getMatterLevel());
        return result;
    }

    private MessageResource resource = null;

    public MessageResource getResource() {
        return resource;
    }

    public void setResource(MessageResource resource) {
        this.resource = resource;
    }

    private List messages = null;

    public void add(Message message) {
        if (this.messages == null)
            this.messages = new ArrayList();
        messages.add(message);
    }

    public Message addMessage(String text, MessageLevel type) {
        final Message message = new MessageImpl(text, type);
        add(message);
        return message;
    }

    private ParameterizedMessageResource formatResource = null;

    protected String format(String key, Map parameters) {
        if (formatResource == null)
            formatResource = new ParameterizedMessageResourceImpl(this.getResource());
        return formatResource.getMessage(key, parameters);
    }

    public Message addMessageByKey(String key, MessageLevel type, Map parameters) {
        final String msg = format(key, parameters);
        return addMessage(msg, type);
    }

    public Message addFatal(String key, Map parameters) {
        return addMessageByKey(key, MessageLevel.FATAL, parameters);
    }

    public Message addError(String key, Map parameters) {
        return addMessageByKey(key, MessageLevel.ERROR, parameters);
    }

    public Message addWarn(String key, Map parameters) {
        return addMessageByKey(key, MessageLevel.WARN, parameters);
    }

    public Message addInfo(String key, Map parameters) {
        return addMessageByKey(key, MessageLevel.INFO, parameters);
    }

    public Message addDebug(String key, Map parameters) {
        return addMessageByKey(key, MessageLevel.DEBUG, parameters);
    }

    public Message addMessageByKey(String key, MessageLevel type) {
        return addMessageByKey(key, type, Collections.EMPTY_MAP);
    }

    public Message addFatal(String key) {
        return addFatal(key, Collections.EMPTY_MAP);
    }

    public Message addError(String key) {
        return addError(key, Collections.EMPTY_MAP);
    }

    public Message addWarn(String key) {
        return addWarn(key, Collections.EMPTY_MAP);
    }

    public Message addInfo(String key) {
        return addInfo(key, Collections.EMPTY_MAP);
    }

    public Message addDebug(String key) {
        return addDebug(key, Collections.EMPTY_MAP);
    }

    public void addMessages(ValidationContext subContext) {
        final List messages = subContext.getMessages();
        for (Iterator i = messages.iterator(); i.hasNext();) {
            this.add((Message) i.next());
        }
    }

    public boolean isEmptyMessage() {
        return (this.messages == null) ? true : this.messages.isEmpty();
    }

    public List getMessages() {
        return (this.messages != null) ? messages : Collections.EMPTY_LIST;
    }

    public List getMessages(final String propertyName) {
        return getMessages(new Predicate() {
            public boolean evaluate(Object object) {
                final Message message = (Message) object;
                return message.containsProperty(propertyName);
            }
        });
    }

    public List getMessages(final MessageLevel level) {
        return getMessages(new Predicate() {
            public boolean evaluate(Object object) {
                final Message message = (Message) object;
                return message.getLevel().isGreaterEqual(level);
            }
        });
    }

    public List getMessages(Predicate predicate) {
        if (this.messages == null)
            return Collections.EMPTY_LIST;
        final List result = new ArrayList();
        for (Iterator i = this.messages.iterator(); i.hasNext();) {
            final Message message = (Message) i.next();
            if (predicate.evaluate(message))
                result.add((message));
        }
        return result;
    }

    public Set getProperties() {
        final Set result = new HashSet();
        for (Iterator i = this.messages.iterator(); i.hasNext();) {
            final Message message = (Message) i.next();
            for (Iterator j = message.iteratorProperties(); j.hasNext();) {
                result.add(j.next());
            }
        }
        return result;
    }

    private MessageLevel matterLevel = MessageLevel.ERROR;

    public MessageLevel getMatterLevel() {
        return this.matterLevel;
    }

    public void setMatterLevel(MessageLevel matterLevel) {
        this.matterLevel = matterLevel;
    }

    public List getMatters() {
        return getMessages(getMatterLevel());
    }

    public String buildText(String delim) {
        final StringBuffer result = new StringBuffer();
        for (Iterator i = getMessages().iterator(); i.hasNext();) {
            final Message message = (Message) i.next();
            result.append("[").append(message.getLevel().getName()).append("] ");
            result.append(message.getText());
            if (i.hasNext())
                result.append(delim);
        }
        return result.toString();
    }

}