/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 16:07:43
 */
package org.asyrinx.brownie.validator.prop;

import java.util.Map;

import org.asyrinx.brownie.validator.ValidationContext;

/**
 * @author takeshi
 */
public class AcceptableCharacter extends AbstractPropertyValidator {

    /**
     * @param propertyName
     */
    public AcceptableCharacter(String propertyName, String displayName, String chars) {
        this(propertyName, displayName, chars, false);
    }

    /**
     * @param propertyName
     */
    public AcceptableCharacter(String propertyName, String displayName, String chars, boolean refuse) {
        super(propertyName, displayName);
        this.chars = chars;
        this.refuse = refuse;
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (!checkAcceptable((String) propertyValue))
            this.addError(context);
    }

    private final String chars;

    private final boolean refuse;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.validator.prop.AbstractPropertyValidator#getMessageKey()
     */
    protected String getMessageKey() {
        return super.getMessageKey() + ((this.refuse ? ".refuse" : ".accept"));
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("acceptable", getChars());
    }

    /**
     * @param propValue
     * @return
     */
    private boolean checkAcceptable(String propValue) {
        if (propValue == null)
            return true;
        for (int i = 0; i < propValue.length(); i++) {
            final char c = propValue.charAt(i);
            if (this.chars.indexOf(c) < 0)
                return false;
        }
        return true;
    }

    public String getChars() {
        return chars;
    }

    public boolean isRefuse() {
        return refuse;
    }
}