/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/04 17:18:22
 */
package org.asyrinx.brownie.validator.prop;

import java.io.UnsupportedEncodingException;
import java.util.Map;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidatorRuntimeException;

/**
 * @author takeshi
 */
public class MaxByteLength extends AbstractPropertyValidator {

    /**
     *  
     */
    public MaxByteLength(String propertyName, String displayName, int maxLength) {
        super(propertyName, displayName);
        this.maxLength = maxLength;
    }

    private final int maxLength;

    private String charset = null;

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (propertyValue == null)
            return;
        try {
            final int length = StringUtils.getByteSize((String) propertyValue, getCharset());
            if (length > maxLength)
                addError(context);
        } catch (UnsupportedEncodingException e) {
            throw new ValidatorRuntimeException(e);
        }
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("maxLength", new Integer(getMaxLength()));
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getMaxLength() {
        return maxLength;
    }
}