/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/24 16:43:56
 */
package test.java.text;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

import org.apache.commons.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.ObjectUtils;
import org.asyrinx.brownie.core.util.SimpleDate;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class DateFormatSymbolsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DateFormatSymbolsTest.class);
    }

    public void testGetMonths() {
        final Locale ja = Locale.JAPANESE;
        //final Locale jp = Locale.JAPAN;
        //System.out.println(ObjectUtils.describeProperties(ja));
        final DateFormatSymbols symbols = new DateFormatSymbols(ja);
        //System.out.println(ObjectUtils.describeProperties(symbols));
        //System.out.println(ArrayUtils.toString(symbols.getAmPmStrings()));
        //System.out.println(ArrayUtils.toString(symbols.getEras()));
        //System.out.println(ArrayUtils.toString(symbols.getLocalPatternChars()));
        //System.out.println(ArrayUtils.toString(symbols.getMonths()));
        //System.out.println(ArrayUtils.toString(symbols.getShortMonths()));
        //System.out.println(ArrayUtils.toString(symbols.getShortWeekdays()));
        //System.out.println(ArrayUtils.toString(symbols.getWeekdays()));
        //System.out.println(ArrayUtils.toString(symbols.getZoneStrings()));
    }

    public void testGetWeekdays() {
        SimpleDate date = new SimpleDate(1973, 12, 31);
        final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        System.out.println(dateFormat.format(date.toDateEnd()));

    }

}